package cn.smarthse.fwgj.model.param.admin;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Classname OrgGjListParam
 * @Description 监管-辖区企业清单
 * @Date 2023/6/29 10:06
 * @Author chenliang
 */
@Data
public class UnitServcieAreaStatisticsTotalParam extends JqGridParam implements Serializable {
    private static final long serialVersionUID = -2077664747855707795L;

    @NotNull(message = "区域不能为空")
    @ApiModelProperty(value = "区域id",required = true)
    private Long areaId;

    @ApiModelProperty(value = "区域等级",required = false)
    private Byte areaLevel;

    @ApiModelProperty(value = "是否包含人数小于3的企业（0否 1是）",required = false)
    private Byte ifIncludeLt3Unit;

    @Deprecated
    @ApiModelProperty(value = "企业等级（0-非直属，1-省直属，2-市属）",required = false)
    private Integer enterpriseLevel;


    @ApiModelProperty(value = "直属企业类（0-非直属，1-省直属，2-市属）",required = false)
    private Integer belongType;

    @ApiModelProperty(value = "直属企业类（0-非直属，1-省直属，2-市属）",required = false)
    private Integer includeBelongType;


    @ApiModelProperty(value = "等级筛选条件（0全部 1仅显示本级 2仅显示非本级）",required = false)
    private Integer companyLevelType;

    //区域详情相关字段
//    @ApiModelProperty(value = "关键词",required = false)
//    private String keyword;
//
//    @ApiModelProperty(value = "市本级企业条件（null or 0：全部企业，1：显示市本级企业）")
//    private Byte municipalLevel;
//
//    @ApiModelProperty(value = "检查预警条件（null or 0：全部企业，1：存在检查预警）")
//    private Byte alarm;
//
//    @ApiModelProperty(value = "合约即将到期企业（null or 0：全部企业，1：合约即将到期企业）")
//    private Byte aboutToExpire;
//
//    @ApiModelProperty(value = "即将到期未服务（null or 0:全部，1：已服务企业，2：需服务企业；3服务超期企业）",required = false)
//    private Byte serviceStatus;
}
