package cn.smarthse.fwgj.model.param.admin;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Classname OrgGjListParam
 * @Description 监管-辖区企业清单
 * @Date 2023/6/29 10:06
 * @Author chenliang
 */
@Data
public class UnitServcieAreaStatisticsListParam extends JqGridParam implements Serializable {
    private static final long serialVersionUID = -2077664747855707795L;

    @NotNull(message = "区域不能为空")
    @ApiModelProperty(value = "区域id",required = true)
    private Long areaId;

    @ApiModelProperty(value = "区域等级",required = false)
    private Byte areaLevel;

    @ApiModelProperty(value = "是否包含人数小于3的企业（0否 1是）",required = false)
    private Byte ifIncludeLt3Unit;

    @Deprecated
    @ApiModelProperty(value = "企业等级（0-非直属，1-省直属，2-市属）",required = false)
    private Byte enterpriseLevel;

    @ApiModelProperty(value = "直属企业类（0-非直属，1-省直属，2-市属）",required = false)
    private Integer belongType;

    @ApiModelProperty(value = "直属企业类（0-非直属，1-省直属，2-市属）",required = false)
    private Integer includeBelongType;
}
