package cn.smarthse.fwgj.model.param.admin;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Classname OrgGjListParam
 * @Description 监管-服务管家信息名单
 * @Date 2023/6/29 10:06
 * @Author chenliang
 */
@Data
public class OrgGjStatisticsListParam extends JqGridParam implements Serializable {
    private static final long serialVersionUID = 1674521422652621939L;

    @NotNull(message = "区域不能为空")
    @ApiModelProperty(value = "区域id",required = true)
    private Long areaId;

    @ApiModelProperty(value = "区域等级",required = false)
    private Byte areaLevel;

    @ApiModelProperty(value = "年份",required = false)
    private Integer currentYear;

    @ApiModelProperty(value = "服务企业数排序（0升序，1降序）",required = false)
    private Integer cmNumSortValue;

    @ApiModelProperty(value = "专业职称",required = false)
    private String post;

    @ApiModelProperty(value = "文化程度",required = false)
    private String edu;

    @ApiModelProperty(value = "就显示市级备案区域(null or 0否 1是)",required = false)
    private Integer onlyCityLevel;

    @ApiModelProperty(value = "是否禁用(0-启用；1-禁用)")
    private Integer isForbidden;

    @ApiModelProperty(value = "机构是否启用（0否 1是）",required = false)
    private Integer orgIsEnable;

    @ApiModelProperty(value = "市级账号的区域",required = false)
    private Long onlyCityAreaId;


}
