package cn.smarthse.fwgj.model.param.admin;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Classname OrgGjListParam
 * @Description 监管-服务管家审核tab统计
 * @Date 2023/6/29 10:06
 * @Author chenliang
 */
@Data
public class OrgAuditTabStatisticsParam implements Serializable {

    private static final long serialVersionUID = -8677600942182338261L;

    @NotNull(message ="区域id不能为空")
    @ApiModelProperty(value = "区域id",required = true)
    private Long areaId;

    @ApiModelProperty(value = "区域等级",required = false)
    private Byte areaLevel;

    @ApiModelProperty(value = "就显示市级备案区域(null or 0否 1是)",required = false)
    private Integer onlyCityLevel;

    @ApiModelProperty(value = "市级账号的区域",required = false)
    private Long onlyCityAreaId;

}
