package cn.smarthse.fwgj.model.param.admin;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Classname OrgGjListParam
 * @Description 监管-服务管家新增审核-服务管家机构审核统计列表
 * @Date 2023/6/29 10:06
 * @Author chenliang
 */
@Data
public class OrgAuditListParam extends JqGridParam implements Serializable {
    private static final long serialVersionUID = 1674521422652621939L;

    @NotNull(message ="区域id不能为空")
    @ApiModelProperty(value = "区域id",required = true)
    private Long areaId;

    @NotNull(message ="列表类型不能为空")
    @ApiModelProperty(value = "机构列表类型（1服务管家新增审核机构列表 2服务管家禁用查看机构列表 3服务管家启用审核机构列表）",required = true)
    private Integer listType;

    @ApiModelProperty(value = "区域等级",required = false)
    private Byte areaLevel;

    @ApiModelProperty(value = "审核状态(0无待处理 1有待处理)",required = false)
    private Integer auditStatus;

    @ApiModelProperty(value = "就显示市级备案区域(null or 0否 1是)",required = false)
    private Integer onlyCityLevel;

    @ApiModelProperty(value = "市级账号的区域",required = false)
    private Long onlyCityAreaId;

}
