package cn.smarthse.fwgj.model.param.admin;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Classname OneOrgStatisticsParam
 * @Description 单个机构服务统计参数
 * @Date 2023/7/12 10:42
 * @Author chenliang
 */
@Data
public class OneOrgStatisticsParam implements Serializable {

    private static final long serialVersionUID = -9218894714820843014L;

    @NotNull(message = "区域不能为空")
    @ApiModelProperty(value = "区域id",required = true)
    private Long areaId;

    @ApiModelProperty(value = "区域等级",required = true)
    private Byte areaLevel;

    @NotNull(message = "机构id不能为空")
    @ApiModelProperty(value = "机构id",required = true)
    private Long oid;
}
