package cn.smarthse.fwgj.model.param.admin;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Classname AddedInfoReviewBatchParam
 * @Description 监管-服务管家信息审核列表-新增审核参数
 * @Date 2023/6/29 10:06
 * @Author chenliang
 */
@Data
public class AddedInfoReviewBatchParam implements Serializable {
    private static final long serialVersionUID = 1674521422652621939L;

    @NotNull(message ="管家与机构的签约id不能为空")
    @ApiModelProperty(value = "管家与机构的签约id",required = true)
    private List<Long> thirdGjUserLogIdList;

    @NotNull(message ="操作类型不能为空")
    @ApiModelProperty(value = "操作类型(0 退回；1 通过)",required = true)
    private Integer optType;

    @ApiModelProperty(value = "操作人",required = true)
    private Long operator;

    @ApiModelProperty(value = "操作人名",required = true)
    private String operatorName;

    @ApiModelProperty(value = "原因",required = true)
    private String reason;

}
