package cn.smarthse.fwgj.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 未签约状态类型(0-无；1-发起解约后变更；2-到期后变更)
 * tips：用于区分是到期后变成的未签约还是退回变成的未签约
 *
 * @author chuhy
 * @date 2023/7/3 14:27
 */
@AllArgsConstructor
@Getter
public enum ThirdGjOrgCustomerUnsignTypeEnum {

    /**
     * 0-无
     */
    NONE(0, "无"),
    /**
     * 1-发起解约后变更
     */
    CANCEL(1, "发起解约后变更"),
    /**
     * 2-到期后变更
     */
    EXPIRE(2, "到期后变更"),
    /**
     * 3-监管禁用机构备案后变更
     */
    FORBIDDEN(3, "监管禁用机构备案后变更"),
    /**
     * 4-监管直接解约
     */
    ADMIN_CANCEL(4, "监管解约后变更"),

    ;

    private final Integer value;

    private final String name;

}
