package cn.smarthse.fwgj.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 *
 * 机构：管家服务-机构、企业签约状态（0：续约待生效；1：签约待审核；2：已签约；3：签约被退回；4：解约待审核；5：已解约；6：解约被退回）
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/7/3 14:27
 */
@AllArgsConstructor
@Getter
public enum ThirdGjOrgCustomerStateEnum {
    /**
     * 1-签约待审核
     */
    sign_not_effective(0, "续约待生效"),
    /**
     * 1-签约待审核
     */
    sign_audit(1, "签约待审核"),
    /**
     * 2-已签约
     */
    sign(2, "已签约"),
    /**
     * 3-签约被退回
     */
    sign_refued(3, "签约被退回"),
    /**
     * 4-解约待审核
     */
    cancel_audit(4, "解约待审核"),
    /**
     * 5-已解约(未签约)
     */
    cancel(5, "已解约"),
    /**
     * 6-解约被退回
     */
    cancel_refued(6, "解约被退回"),
    ;

    private final Integer value;

    private final String name;

    public static String getName(Integer value) {

        ThirdGjOrgCustomerStateEnum[] enums = values();

        for (ThirdGjOrgCustomerStateEnum record : enums) {
            if (record.value.equals(value)) {
                return record.name;
            }
        }
        return null;
    }

}
