package cn.smarthse.fwgj.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 *
 * 机构：机构、企业签约来源 （1-监管创建；2-机构创建；3-用人单位）
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/7/3 14:27
 */
@AllArgsConstructor
@Getter
public enum ThirdGjOrgCustomerSourceEnum {

    /**
     * 1-监管
     */
    SUPERVISE(1, "监管创建"),
    /**
     * 2-机构
     */
    THIRD_ORG(2, "机构创建"),
    /**
     * 3-用人单位
     */
    COMPANY(3, "用人单位"),

    ;

    private final Integer value;

    private final String name;

}
