package cn.smarthse.fwgj.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 *
 * 服务管家 审核记录类型
 *  记录类型：1-管家机构申请审核记录；2-管家机构签约企业审核记录；3-管家机构解约企业审核记录；4-管家账号审核记录
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/7/3 16:13
 */
@AllArgsConstructor
@Getter
public enum ThirdGjOrgAuditLogTypeEnum {

    /**
     * 1-管家机构申请审核记录
     */
    third_gj_org(1, "管家机构申请审核记录"),
    /**
     * 2-管家机构签约企业审核记录
     */
    third_gj_org_customer_sign(2, "管家机构签约企业审核记录"),
    /**
     * 3-管家机构签约企业审核记录
     */
    third_gj_org_customer_cancel(3, "管家机构解约企业审核记录"),
    /**
     * 4-管家账号审核记录
     */
    third_gj_user_log(4, "管家账号审核记录"),
    /**
     * 6-管家服务记录审核认定操作
     */
    check_info_opt(6, "管家账号审核记录"),
    /**
     * 7-服务检查补录审核记录
     */
    check_info_supply_opt(7, "服务检查补录审核记录"),
    ;

    private final Integer value;

    private final String name;

}
