package cn.smarthse.fwgj.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 *
 * 机构：管家服务-机构、企业,当前的上\下半周期(1-上半周期；2-下半周期)
 *
 * @author chuhy
 * @date 2023/7/3 14:27
 */
@AllArgsConstructor
@Getter
public enum GjCustomerCycleEnum {

    /**
     * 1-上半周期
     */
    FIRST(1, "上半周期"),
    /**
     * 2-下半周期
     */
    SECOND(2, "下半周期"),

    ;

    private final Integer value;

    private final String name;

    public static String getName(Integer value) {
        GjCustomerCycleEnum[] cycleEnums = values();
        for (GjCustomerCycleEnum cycleEnum : cycleEnums) {
            if (cycleEnum.value.equals(value)) {
                return cycleEnum.name;
            }
        }
        return null;
    }


}
