package cn.smarthse.fwgj.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 上\下半周期服务状态(0-未开始；1-进行中；2-已完成；3-未完成)
 * 根据当前周期中系统自动创建检查记录的检查状态(CheckStatusEnums)决定，其中CheckStatusEnums.DONE、END对应当前枚举类中的DONE
 * @author chuhy
 * @date 2023/7/3 14:27
 */
@AllArgsConstructor
@Getter
public enum GjCustomerCheckStatusEnum {


    /**
     * 0-未开始
     */
    NOT_STARTED(0, "未开始"),
    /**
     * 1-进行中
     */
    CHECKING(1, "进行中"),
    /**
     * 2-已完成(包含了CheckStatusEnums.DONE、END)
     */
    DONE(2, "已完成"),
    /**
     * 3-未完成
     */
    INCOMPLETE(3, "未完成"),

    ;

    private final Integer value;

    private final String name;

    public static String getName(Integer value) {
        GjCustomerCheckStatusEnum[] cycleEnums = values();
        for (GjCustomerCheckStatusEnum cycleEnum : cycleEnums) {
            if (cycleEnum.value.equals(value)) {
                return cycleEnum.getName();
            }
        }
        return null;
    }


}
