package cn.smarthse.fwgj.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 *
 * 机构：管家服务-机构、企业,是否为系统自动创建的服务检查
 *(0-否；1-是)
 * @author chuhy
 * @date 2023/7/3 14:27
 */
@AllArgsConstructor
@Getter
public enum GjCustomerAutoCreateEnum {


    /**
     * 0-不是自动创建的检查记录
     */
    NOT_AUTO(0, "不是自动创建的检查记录"),
    /**
     * 1-是自动创建的检查记录
     */
    IS_AUTO(1, "是自动创建的检查记录"),

    ;

    private final Integer value;

    private final String name;

    public static String getName(Integer value) {
        GjCustomerAutoCreateEnum[] cycleEnums = values();
        for (GjCustomerAutoCreateEnum cycleEnum : cycleEnums) {
            if (cycleEnum.value.equals(value)) {
                return cycleEnum.name();
            }
        }
        return null;
    }


}
