package cn.smarthse.fwgj.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 检查记录 - 预警状态(0-无预警；1-检查预警；2-超期小于等于30天；3-超期大于30天)
 * @author chuhy
 * @date 2023/7/3 14:27
 */
@AllArgsConstructor
@Getter
public enum GjCheckInfoWarningStatusEnum {


    /**
     * 0-无预警
     */
    NO_WARNING(0, "无预警"),
    /**
     * 1-检查预警(半周期下最后一个月内，不包括第一天)
     */
    WARNING(1, "检查预警"),
    /**
     * 2-超期小于等于30天
     */
    EXPIRED_LESS(2, "超期小于等于30天"),
    /**
     * 3-超期大于30天
     */
    EXPIRED_MORE(3, "超期大于30天")

    ;

    private final Integer value;

    private final String name;

    public static String getName(Integer value) {
        GjCheckInfoWarningStatusEnum[] cycleEnums = values();
        for (GjCheckInfoWarningStatusEnum cycleEnum : cycleEnums) {
            if (cycleEnum.value.equals(value)) {
                return cycleEnum.name();
            }
        }
        return null;
    }


}
