package cn.smarthse.fwgj.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 检查记录 - 补录状态(0-无需补录；1-可补录；2-不可补录；3-补录中；4-补录完成)
 * @author chuhy
 * @date 2023/7/3 14:27
 */
@AllArgsConstructor
@Getter
public enum GjCheckInfoSupplyStatusEnum {


    /**
     * 0-无需补录(初始状态)
     */
    NO_NEED_SUPPLY(0, "无需补录"),
    /**
     * 1-可补录
     */
    COULD_SUPPLY(1, "可补录"),
    /**
     * 2-不可补录
     */
    CANT_SUPPLY(2, "不可补录"),
    /**
     * 3-补录中(废弃),审核通过后，直接从不可补录变为可补录
     */
    @Deprecated
    SUPPLYING(3, "补录中"),
    /**
     * 4-补录完成
     */
    SUPPLIED(4, "补录完成")

    ;

    private final Integer value;

    private final String name;

    public static String getName(Integer value) {
        GjCheckInfoSupplyStatusEnum[] cycleEnums = values();
        for (GjCheckInfoSupplyStatusEnum cycleEnum : cycleEnums) {
            if (cycleEnum.value.equals(value)) {
                return cycleEnum.name();
            }
        }
        return null;
    }


}
