package cn.smarthse.fwgj.entity.thirdGj;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 管管家服务-监管添加签约记录
 *
 * @author wuxq
 * @date 2023/6/29 09:34
 */
@Data
@Table(name = "third_gj_org_customer_lot_detail")
public class ThirdGjOrgCustomerLotDetail implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @TableId(value = "id")
    private Long id;
    /**
     * third_gj_org_customer_lot.id
     */
    private Long lotId;
    /**
     * 签约单位id
     */
    private Long cid;

    /**
     * 直属企业类型（0-非直属，1-省直属，2-市属）来源数据中心
     */
    private Integer belongType;

    /**
     * 签约单位名称
     */
    private String unitName;
    /**
     * 统一社会信用代码
     */
    private String unitCreditCode;
    /**
     * 行政区划
     */
    private Long areaId;

    /**
     * 企业联系人
     */
    private String unitMan;
    /**
     * 企业联系电话
     */
    private String unitTel;
    /**
     * 省id
     */
    private Long areaId1;
    /**
     * 市id
     */
    private Long areaId2;
    /**
     * 区id
     */
    private Long areaId3;
    /**
     * 街道id
     */
    private Long areaId4;
    /**
     * 地址
     */
    private String address;
    /**
     * 签约时间
     */
    private Date signTime;
    /**
     * 到期时间
     */
    private Date expireTime;

    @ApiModelProperty("创建时间")
    private LocalDateTime createDate;

    @ApiModelProperty("更新时间")
    private LocalDateTime updateDate;

    @ApiModelProperty("创建人")
    private Long createBy;

    @ApiModelProperty("更新人")
    private Long updateBy;

    @TableLogic
    @TableField(select = true)
    @ApiModelProperty(value = "是否有效（1-有效；0-无效）")
    private Integer isValid;



}
