package cn.smarthse.fwgj.entity.thirdGj;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;
import javax.persistence.Table;
import lombok.Data;

/**
 * 机构：机构管家添加企业清单批次
 *
 * @author wuxq
 * @date 2023/6/29 09:34
 */
@Data
@Table(name = "third_gj_org_customer_lot")
public class ThirdGjOrgCustomerLot implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @TableId(value = "id")
    private Long id;
    /**
     * 机构id
     */
    private Long orgId;
    /**
     * 管家机构id
     */
    private Long gjOrgId;
    /**
     * 机构名称
     */
    private String orgName;
    /**
     * 机构联系人
     */
    private String orgMan;
    /**
     * 机构联系电话
     */
    private String orgTel;
    /**
     * 机构地址
     */
    private String address;
    /**
     * 行政区划id（服务范围）
     */
    private Long areaId;
    /**
     * 行政区划level（服务范围）
     */
    private Integer level;
    /**
     * 省id
     */
    private Long areaId1;
    /**
     * 市id
     */
    private Long areaId2;
    /**
     * 区id
     */
    private Long areaId3;
    /**
     * 签约时间
     */
    private Date signTime;
    /**
     * 到期时间
     */
    private Date expireTime;
    /**
     * 提交时间
     */
    private Date subTime;
    /**
     * 状态（0-草稿；1-已添加）
     */
    private Integer state;
    /**
     * 区域勾选记录（,分隔）
     */
    private String chooseAreas;
    /**
     * 添加企业数
     */
    @TableField(exist = false)
    private Integer addCompNum;

    @ApiModelProperty("创建时间")
    private Date createDate;

    @ApiModelProperty("更新时间")
    private Date updateDate;

    @ApiModelProperty("创建人")
    private Long createBy;

    @ApiModelProperty("更新人")
    private Long updateBy;

    @TableLogic
    @TableField(select = true)
    @ApiModelProperty(value = "是否有效（1-有效；0-无效）")
    private Integer isValid;
}
