package cn.smarthse.fwgj.entity.thirdGj;

import cn.smarthse.common.util.date.DateUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 管家服务机构申请、企业签约审核记录
 *
 * @author wuxq
 * @date 2023/6/29 09:34
 */
@Accessors(chain = true)
@Data
@Table(name = "third_gj_org_customer_audit_log")
public class ThirdGjOrgAuditLog implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @TableId(value = "id")
    private Long id;
    /**
     * 记录类型：1-管家机构申请审核记录；2-管家机构签约企业审核记录；3-管家机构解约企业审核记录；4-管家账号审核记录 (ThirdGjOrgAuditLogTypeEnum)
     */
    private Integer type;
    /**
     * 关联业务id（type：1-third_gj_org.id；2-third_gj_org_customer.id；3-third_gj_user_log.id）
     */
    private Long businessId;
    /**
     * 签约单位名称
     */
    private String unitName;
    /**
     * 操作编码（发起签约、签约成功、退回签约等）ThirdGjOrgAuditOptEnum
     */
    private Integer optValue;
    /**
     * 操作（发起签约、签约成功、退回签约等）
     */
    private String opt;
    /**
     * 操作人（机构、监管名称）
     */
    private String optPeople;

    /**
     * 操作描述/理由
     */
    private String optDesc;

    @ApiModelProperty("创建时间")
    private Date createDate;

    @ApiModelProperty("创建时间")
    @TableField(exist = false)
    private String createDateStr;

    @ApiModelProperty("更新时间")
    private Date updateDate;

    @ApiModelProperty("创建人")
    private Long createBy;

    @ApiModelProperty("更新人")
    private Long updateBy;

    @TableLogic
    @TableField(select = true)
    @ApiModelProperty(value = "是否有效（1-有效；0-无效）")
    private Integer isValid;

    public String getCreateDateStr() {
        if (this.createDate != null) {
            return DateUtil.format(this.createDate, "yyyy-MM-dd HH:mm:ss");
        }
        return "";
    }
}
