
package cn.smarthse.fwgj.entity.sys;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.Pattern;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 机构：管家-账号
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/6/20 13:34
 */
@TableName("third_gj_user")
public @Data class ThirdGjUser implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id")
    private Long id;

    /**
     * 用户名
     */
    @ApiModelProperty("账号")
    private String username;
    /**
     * 登录加密密码（SHA-1）
     */
    @ApiModelProperty(hidden = true)
    private String password;
    /**
     * 登录盐值
     */
    @ApiModelProperty(hidden = true)
    private String salt;
    /**
     * 用户姓名
     */
    @ApiModelProperty("用户姓名")
    private String fullname;
    /**
     * 手机号码
     */
    @ApiModelProperty("手机号码")
    private String mobile;
    /**
     * 身份证
     */
    @ApiModelProperty("身份证")
    //@Pattern(regexp = "^[1-9]\\d{5}(19|20)\\d{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2]\\d|3[0-1])|(04|06|09|11)(0[1-9]|[1-2]\\d|30)|02(0[1-9]|[1-2]\\d))\\d{3}[\\dXx]$")
    private String idcard;

    /**
     * 性别（男；女）
     */
    @ApiModelProperty("性别（男；女）")
    private String sex;
    /**
     * 出生日期
     */
    @ApiModelProperty("出生日期")
    private Date birthday;
    /**
     * 从业年限/年
     */
    @ApiModelProperty("从业年限/年")
    private Integer workYear;
    /**
     * 专业职称
     */
    @ApiModelProperty("专业职称")
    private String post;
    /**
     * 文化程度
     */
    @ApiModelProperty("文化程度")
    private String edu;
    /**
     * 头像文件编号（file.id)
     */
    @ApiModelProperty("头像文件编号（file.id)")
    private Long faceId;
    /**
     * 是否禁用
     */
    @ApiModelProperty("是否禁用")
    private Integer isForbidden;
    /**
     * 禁用、启用时间
     */
    @ApiModelProperty("禁用、启用时间")
    private Date forbiddenDate;
    /**
     * 是否是默认密码
     */
    @ApiModelProperty("是否是默认密码")
    private Boolean isDefaultPwd;
    /**
     * 密码修改时间
     */
    @ApiModelProperty("密码修改时间")
    private Date pwdUpdateTime;

    @ApiModelProperty("创建时间")
    private LocalDateTime createDate;

    @ApiModelProperty("更新时间")
    private LocalDateTime updateDate;

    @ApiModelProperty("创建人")
    private Long createBy;

    @ApiModelProperty("更新人")
    private Long updateBy;

    @TableLogic
    @TableField(select = true)
    @ApiModelProperty(value = "是否有效（1-有效；0-无效）")
    private Integer isValid;
    /**
     * 浙里办userId
     */
    private String zlbUserId;

    @ApiModelProperty("管家账号log id")
    @TableField(exist = false)
    private Long gjUserLogId;
}
