package cn.smarthse.fwgj.converter.check;

import cn.smarthse.fwgj.model.param.check.AddReformParam;
import cn.smarthse.fwgj.model.vo.check.ReformListVo;
import cn.smarthse.fwgj.model.vo.check.ReformVo;
import cn.smarthse.modules.health.vo.summary.ReformAddParamXzxg;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

import java.util.List;

@Mapper(componentModel = "spring")
public interface ReformConverter {

    cn.smarthse.fwgj.converter.check.ReformConverter INSTANCE = Mappers.getMapper(cn.smarthse.fwgj.converter.check.ReformConverter.class);

    /**
     * vo 转 listVo
     */
    @Mapping(target = "isThisFind", constant = "0")
    ReformListVo reformVoToReformListVo(ReformVo vo);

    /**
     * vo 转 listVo
     */
    List<ReformListVo> voToListVo(List<ReformVo> vo);


    /**
     * 前端param 转 风险param
     */
    @Mappings(value = {
            @Mapping(target = "name", source = "reformName"),
            @Mapping(target = "reformItemSourceId", source = "checkId"),
    })
     ReformAddParamXzxg addParamToReformParam(AddReformParam param);

    /**
     * 前端param 转 风险param
     */
    List<ReformAddParamXzxg> addParamToReformParam(List<AddReformParam> paramList);

}
