/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.tencent.weixin;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;

public class WeixinSignUtil {
    public static Map<String, String> paraFilter(Map<String, String> sArray) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (sArray == null || sArray.size() <= 0) {
            return result;
        }
        for (String key : sArray.keySet()) {
            String value = sArray.get(key);
            if (value == null || value.equals("") || key.equalsIgnoreCase("sign") || key.equalsIgnoreCase("key")) continue;
            result.put(key, value);
        }
        return result;
    }

    public static String createLinkString(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String prestr = "";
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            prestr = i == keys.size() - 1 ? prestr + key + "=" + value : prestr + key + "=" + value + "&";
        }
        return prestr;
    }

    public static String buildRequestSign(Map<String, String> sPara, String API_KEY) {
        Map<String, String> sParaTemp = WeixinSignUtil.paraFilter(sPara);
        String prestr = WeixinSignUtil.createLinkString(sParaTemp);
        String mysign = WeixinSignUtil.sign(prestr, API_KEY, "UTF-8");
        return mysign.toUpperCase();
    }

    public static String sign(String text, String key, String charset) {
        text = text + "&key=" + key;
        return DigestUtils.md5Hex((byte[])WeixinSignUtil.getContentBytes(text, charset));
    }

    private static byte[] getContentBytes(String content, String charset) {
        if (charset == null || "".equals(charset)) {
            return content.getBytes();
        }
        try {
            return content.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("MD5\u7b7e\u540d\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef,\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u4e0d\u5bf9,\u60a8\u76ee\u524d\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u662f:" + charset);
        }
    }

    public static String createSign(SortedMap<String, Object> packageParams, String key) {
        StringBuffer sb = new StringBuffer();
        Set<Map.Entry<String, Object>> es = packageParams.entrySet();
        for (Map.Entry<String, Object> entry : es) {
            String k = entry.getKey();
            String v = (String)entry.getValue();
            if (null == v || "".equals(v) || "sign".equals(k) || "key".equals(k)) continue;
            sb.append(k + "=" + v + "&");
        }
        sb.append("key=").append(key);
        String sign = DigestUtils.md5Hex((byte[])WeixinSignUtil.getContentBytes(sb.toString(), "UTF-8"));
        return sign;
    }

    public static boolean verifySign(Map<Object, Object> map, String key) {
        TreeMap<String, Object> parameterMap = new TreeMap<String, Object>();
        String sign = (String)map.get("sign");
        for (Object keyValue : map.keySet()) {
            if (keyValue.toString().equals("sign")) continue;
            parameterMap.put(keyValue.toString(), map.get(keyValue));
        }
        String createSign = WeixinSignUtil.createSign(parameterMap, key);
        System.out.println("Weixin Sign=" + sign + ", My Sign=" + createSign);
        return createSign.equals(sign);
    }
}

