/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.tencent.weixin;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class WeiXinJsUtil {
    public static Map<String, String> sign(String jsapi_ticket, String url) {
        String nonce_str = WeiXinJsUtil.create_nonce_str();
        String timestamp = WeiXinJsUtil.create_timestamp();
        return WeiXinJsUtil.sign(jsapi_ticket, nonce_str, timestamp, url);
    }

    public static Map<String, String> sign(String jsapi_ticket, String nonce_str, String timestamp, String url) {
        HashMap<String, String> ret = new HashMap<String, String>();
        String signature = "";
        Object[] paramArr = new String[]{"jsapi_ticket=" + jsapi_ticket, "timestamp=" + timestamp, "noncestr=" + nonce_str, "url=" + url};
        Arrays.sort(paramArr);
        String content = ((String)paramArr[0]).concat("&" + (String)paramArr[1]).concat("&" + (String)paramArr[2]).concat("&" + (String)paramArr[3]);
        System.out.println("\u62fc\u63a5\u4e4b\u540e\u7684content\u4e3a:" + content);
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(content.getBytes("UTF-8"));
            signature = WeiXinJsUtil.byteToHex(crypt.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ret.put("url", url);
        ret.put("jsapi_ticket", jsapi_ticket);
        ret.put("nonceStr", nonce_str);
        ret.put("timestamp", timestamp);
        ret.put("signature", signature);
        return ret;
    }

    public static String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }

    public static String create_nonce_str() {
        return UUID.randomUUID().toString();
    }

    public static String create_timestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }

    public static void main(String[] args) {
    }
}

