/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.tencent.weixin;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.web.bind.annotation.RequestMethod;

public class WeiXinHttpUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doRefund(String url, String data, String mch_id, String SSLCERT_PATH) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        try (FileInputStream instream = new FileInputStream(new File(SSLCERT_PATH));){
            keyStore.load(instream, mch_id.toCharArray());
        }
        SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, mch_id.toCharArray()).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        try (CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();){
            String string;
            HttpPost httpost = new HttpPost(url);
            httpost.addHeader("Connection", "keep-alive");
            httpost.addHeader("Accept", "*/*");
            httpost.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            httpost.addHeader("Host", "api.mch.weixin.qq.com");
            httpost.addHeader("X-Requested-With", "XMLHttpRequest");
            httpost.addHeader("Cache-Control", "max-age=0");
            httpost.setEntity((HttpEntity)new StringEntity(data, "UTF-8"));
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpost);
            try {
                HttpEntity entity = response.getEntity();
                String jsonStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                EntityUtils.consume((HttpEntity)entity);
                string = jsonStr;
            }
            catch (Throwable throwable) {
                response.close();
                throw throwable;
            }
            response.close();
            return string;
        }
    }

    public static String doGet(String url) throws Exception {
        return WeiXinHttpUtil.doHttp(url, null, RequestMethod.GET);
    }

    public static String doGet(String url, String data) throws Exception {
        return WeiXinHttpUtil.doHttp(url, data, RequestMethod.GET);
    }

    public static String doPost(String url, String data) throws Exception {
        return WeiXinHttpUtil.doHttp(url, data, RequestMethod.POST);
    }

    public static String doHttp(String url, String data, RequestMethod method) throws Exception {
        URL urlGet = new URL(url);
        HttpURLConnection http = (HttpURLConnection)urlGet.openConnection();
        http.setRequestMethod(method.name());
        http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        http.setDoOutput(true);
        http.setDoInput(true);
        System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
        System.setProperty("sun.net.client.defaultReadTimeout", "30000");
        http.connect();
        if (StringUtils.isNotEmpty((CharSequence)data)) {
            OutputStream os = http.getOutputStream();
            os.write(data.getBytes("UTF-8"));
            os.flush();
            os.close();
        }
        InputStream is = http.getInputStream();
        int size = is.available();
        byte[] jsonBytes = new byte[size];
        is.read(jsonBytes);
        return new String(jsonBytes, "UTF-8");
    }

    public static JSONObject post(String urlPath, String data) throws Exception {
        String message = WeiXinHttpUtil.doPost(urlPath, data);
        return JSONObject.fromObject((Object)message);
    }

    public static JSONObject get(String urlPath, String data) throws Exception {
        String message = WeiXinHttpUtil.doGet(urlPath, data);
        return JSONObject.fromObject((Object)message);
    }
}

