/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.tencent.weixin.vo.customer;

import cn.smarthse.common.framework.tencent.weixin.vo.customer.WxCustomer;
import cn.smarthse.common.framework.tencent.weixin.vo.customer.WxCustomerMsg;
import cn.smarthse.common.framework.tencent.weixin.vo.send.WxSendNewsMsgItem;
import java.util.List;

public class WxCustomerNewsMsg
extends WxCustomerMsg
implements WxCustomer {
    List<WxSendNewsMsgItem> articles;

    public WxCustomerNewsMsg(String touser, List<WxSendNewsMsgItem> articles) {
        super(touser, "news");
        this.articles = articles;
    }

    @Override
    public String getJson() {
        String base = super.getJson();
        StringBuilder items = new StringBuilder("");
        if (this.articles != null && this.articles.size() > 0) {
            int index = this.articles.size() > 10 ? 10 : this.articles.size();
            for (int i = 0; i < 10; ++i) {
                WxSendNewsMsgItem item = this.articles.get(i);
                items.append("{");
                items.append(",\"title\":\"").append(item.getTitle()).append("\"");
                items.append(",\"description\":\"").append(item.getDescription()).append("\"");
                items.append(",\"url\":\"").append(item.getUrl()).append("\"");
                items.append(",\"picurl\":\"").append(item.getPicUrl()).append("\"");
                items.append("},");
                if (index > i) break;
            }
            if (items.lastIndexOf(",", items.length()) >= 0) {
                items.deleteCharAt(items.length() - 1);
            }
        }
        String data = String.format("\"articles\":[%s]", items.toString());
        base = base.replaceAll("##data##", data);
        return base;
    }

    public List<WxSendNewsMsgItem> getArticles() {
        return this.articles;
    }

    public void setArticles(List<WxSendNewsMsgItem> articles) {
        this.articles = articles;
    }
}

