/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.tencent.weixin;

import cn.smarthse.common.framework.tencent.weixin.WeiXinHttpUtil;
import cn.smarthse.common.framework.tencent.weixin.vo.UserInfoCode;
import cn.smarthse.common.framework.tencent.weixin.vo.UserItem;
import cn.smarthse.common.framework.tencent.weixin.vo.UserUnionInfo;
import net.sf.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WeiXinUserUtil {
    static final Logger logger = LogManager.getLogger(WeiXinUserUtil.class);

    public static UserInfoCode getUserAccessTokenByCode(String APPID, String APPSECRET, String code) throws Exception {
        logger.info("getUserAccessTokenByCode code={}", (Object)code);
        String url = String.format("https://api.weixin.qq.com/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code", APPID, APPSECRET, code);
        String message = WeiXinHttpUtil.doGet(url);
        logger.info(message);
        return new UserInfoCode(JSONObject.fromObject((Object)message));
    }

    public static UserItem getUserInfo(String accessToken, String openid) throws Exception {
        logger.info("getUserInfo accessToken= {} , openid={}", (Object)accessToken, (Object)openid);
        String url = String.format("https://api.weixin.qq.com/sns/userinfo?access_token=%s&openid=%s&lang=zh_CN", accessToken, openid);
        String message = WeiXinHttpUtil.doGet(url);
        logger.info(message);
        return new UserItem(JSONObject.fromObject((Object)message));
    }

    public static UserUnionInfo getUserByOpenId(String openId, String accessToken) {
        logger.info("\u83b7\u53d6\u7528\u6237\u57fa\u672c\u4fe1\u606f\uff08\u5305\u62ecUnionID\u673a\u5236\uff09 accessToken= {} , openid={}", (Object)accessToken, (Object)openId);
        String url = String.format("https://api.weixin.qq.com/cgi-bin/user/info?access_token=%s&openid=%s&lang=zh_CN", accessToken, openId);
        JSONObject json = null;
        try {
            json = WeiXinHttpUtil.get(url, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (json != null) {
            logger.info("\u83b7\u53d6\u7528\u6237\u57fa\u672c\u4fe1\u606f\uff1a{}", (Object)json.toString());
            return new UserUnionInfo(json);
        }
        return null;
    }
}

