/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.tencent.weixin;

import cn.smarthse.common.framework.tencent.weixin.WeiXin;
import cn.smarthse.common.framework.tencent.weixin.WeiXinHttpUtil;
import java.util.HashMap;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WeiXinMenuUtil {
    static final Logger logger = LogManager.getLogger(WeiXinMenuUtil.class);

    public static String createMenu(String menu, String token) {
        String action = "https://api.weixin.qq.com/cgi-bin/menu/create?access_token=" + token;
        try {
            String message = WeiXinHttpUtil.doPost(action, menu);
            return "\u8fd4\u56de\u4fe1\u606f" + message;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "createMenu \u5931\u8d25";
        }
    }

    public static JSONObject createMenu(String menu, String APPID, String APPSECRET) throws JSONException {
        logger.info("\u6839\u636eAPPID\u4e0eAPPSECRET\u521b\u5efa\u83dc\u5355");
        String access_token = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            access_token = WeiXin.getAccess_token(APPID, APPSECRET);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (access_token == null) {
            map.put("code", "0");
            map.put("msg", "access_token error");
            return JSONObject.fromObject(map);
        }
        String action = String.format("https://api.weixin.qq.com/cgi-bin/menu/create?access_token=%s", access_token);
        try {
            JSONObject json = WeiXinHttpUtil.post(action, menu);
            map.put("code", "1");
            map.put("errcode", json.get("errcode"));
            map.put("errmsg", json.get("errmsg"));
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("code", "0");
            map.put("msg", e.getMessage());
        }
        return JSONObject.fromObject(map);
    }

    public static JSONObject deleteMenu(String APPID, String APPSECRET) {
        logger.info("\u6839\u636eAPPID\u4e0eAPPSECRET\u5220\u9664\u81ea\u5b9a\u4e49\u83dc\u5355");
        String access_token = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            access_token = WeiXin.getAccess_token(APPID, APPSECRET);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (access_token == null) {
            map.put("code", "0");
            map.put("msg", "access_token error");
            return JSONObject.fromObject(map);
        }
        try {
            String action = String.format("https://api.weixin.qq.com/cgi-bin/menu/delete?access_token=%s", access_token);
            JSONObject json = WeiXinHttpUtil.get(action, null);
            map.put("code", "1");
            map.put("errcode", json.get("errcode"));
            map.put("errmsg", json.get("errmsg"));
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("code", "0");
            map.put("msg", e.getMessage());
        }
        return JSONObject.fromObject(map);
    }
}

