/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.tencent.weixin;

import cn.smarthse.common.framework.tencent.weixin.WeiXinHttpUtil;
import cn.smarthse.common.framework.tencent.weixin.vo.customer.WxCustomerImageMsg;
import cn.smarthse.common.framework.tencent.weixin.vo.customer.WxCustomerMusicMsg;
import cn.smarthse.common.framework.tencent.weixin.vo.customer.WxCustomerNewsMsg;
import cn.smarthse.common.framework.tencent.weixin.vo.customer.WxCustomerTextMsg;
import cn.smarthse.common.framework.tencent.weixin.vo.customer.WxCustomerVideoMsg;
import cn.smarthse.common.framework.tencent.weixin.vo.customer.WxCustomerVoiceMsg;
import cn.smarthse.common.framework.tencent.weixin.vo.send.WxSendNewsMsgItem;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WeiXinCustomerUtil {
    static final Logger logger = LogManager.getLogger(WeiXinCustomerUtil.class);
    static String baseUrl = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=";

    public static JSONObject sendText(String touser, String text, String token) {
        logger.info("\u3010\u5ba2\u670d\u6d88\u606f\u3011\u53d1\u9001\u6587\u672c\u6d88\u606f");
        String url = baseUrl + token;
        WxCustomerTextMsg txt = new WxCustomerTextMsg(touser, text);
        JSONObject demoJson = null;
        try {
            demoJson = WeiXinHttpUtil.post(url, txt.getJson());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return demoJson;
    }

    public static JSONObject sendImage(String touser, String mediaId, String token) {
        logger.info("\u3010\u5ba2\u670d\u6d88\u606f\u3011\u53d1\u9001\u56fe\u7247\u6d88\u606f");
        String url = baseUrl + token;
        WxCustomerImageMsg img = new WxCustomerImageMsg(touser, mediaId);
        JSONObject demoJson = null;
        try {
            demoJson = WeiXinHttpUtil.post(url, img.getJson());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return demoJson;
    }

    public static JSONObject sendVoice(String touser, String mediaId, String token) {
        logger.info("\u3010\u5ba2\u670d\u6d88\u606f\u3011\u53d1\u9001\u8bed\u97f3\u6d88\u606f");
        String url = baseUrl + token;
        WxCustomerVoiceMsg voice = new WxCustomerVoiceMsg(touser, mediaId);
        JSONObject demoJson = null;
        try {
            demoJson = WeiXinHttpUtil.post(url, voice.getJson());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return demoJson;
    }

    public static JSONObject sendVideo(String touser, String mediaId, String thumbMediaId, String title, String description, String token) {
        logger.info("\u3010\u5ba2\u670d\u6d88\u606f\u3011\u53d1\u9001\u89c6\u9891\u6d88\u606f");
        String url = baseUrl + token;
        WxCustomerVideoMsg video = new WxCustomerVideoMsg(token, mediaId, thumbMediaId, title, description);
        JSONObject demoJson = null;
        try {
            demoJson = WeiXinHttpUtil.post(url, video.getJson());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return demoJson;
    }

    public static JSONObject sendMusic(String touser, String title, String description, String musicurl, String hqmusicurl, String thumbMediaId, String token) {
        logger.info("\u3010\u5ba2\u670d\u6d88\u606f\u3011\u53d1\u9001\u97f3\u9891\u6d88\u606f");
        String url = baseUrl + token;
        WxCustomerMusicMsg music = new WxCustomerMusicMsg(token, title, description, musicurl, hqmusicurl, thumbMediaId);
        JSONObject demoJson = null;
        try {
            demoJson = WeiXinHttpUtil.post(url, music.getJson());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return demoJson;
    }

    public static JSONObject sendNews(String touser, List<WxSendNewsMsgItem> articles, String token) {
        logger.info("\u3010\u5ba2\u670d\u6d88\u606f\u3011\u53d1\u9001\u56fe\u6587\u6d88\u606f");
        String url = baseUrl + token;
        WxCustomerNewsMsg news = new WxCustomerNewsMsg(touser, articles);
        JSONObject demoJson = null;
        try {
            demoJson = WeiXinHttpUtil.post(url, news.getJson());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return demoJson;
    }
}

