/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.tencent.weixin;

import cn.smarthse.common.framework.tencent.weixin.HashKitUtil;
import cn.smarthse.common.framework.tencent.weixin.WeChatTemplate;
import cn.smarthse.common.framework.tencent.weixin.WeiXinHttpUtil;
import cn.smarthse.common.framework.tencent.weixin.model.ExpressTemplate;
import cn.smarthse.common.framework.tencent.weixin.parser.WxMsgKit;
import cn.smarthse.common.framework.tencent.weixin.vo.UserInfoCode;
import cn.smarthse.common.framework.tencent.weixin.vo.UserItem;
import cn.smarthse.common.framework.tencent.weixin.vo.recv.WxRecvMsg;
import cn.smarthse.common.framework.tencent.weixin.vo.send.WxSendMsg;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class WeiXin {
    static final Logger logger = LogManager.getLogger(WeiXin.class);

    public static String getAccess_token(String APPID, String APPSECRET) {
        logger.info("getAccess_token \u83b7\u53d6access_token APPID={}, APPSECRET={}", (Object)APPID, (Object)APPSECRET);
        String accessToken = null;
        String url = String.format("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s", APPID, APPSECRET);
        JSONObject demoJson = null;
        try {
            demoJson = WeiXinHttpUtil.get(url, null);
            if (demoJson.containsKey((Object)"errcode")) {
                logger.error("\u83b7\u53d6Access_token\u5931\u8d25\uff1a" + demoJson.toString() + "-----" + new Date().toString());
                return "";
            }
            return demoJson.getString("access_token");
        }
        catch (Exception e) {
            e.printStackTrace();
            return accessToken;
        }
    }

    public static String getjsapi_ticket(String accesstoken) throws Exception {
        logger.info("getjsapi_ticket \u83b7\u53d6jsapi_ticket accesstoken={}", (Object)accesstoken);
        String url = String.format("https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=%s&type=jsapi", accesstoken);
        JSONObject demoJson = WeiXinHttpUtil.get(url, null);
        logger.info("getjsapi_ticket \u83b7\u53d6jsapi_ticket demoJson=" + demoJson);
        return demoJson.getString("ticket");
    }

    @Deprecated
    public static UserInfoCode getUserAccessTokenByCode(String APPID, String APPSECRET, String code) throws Exception {
        logger.info("getUserAccessTokenByCode code={}", (Object)code);
        String url = String.format("https://api.weixin.qq.com/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code", APPID, APPSECRET, code);
        String message = WeiXinHttpUtil.doGet(url);
        logger.info(message);
        return new UserInfoCode(JSONObject.fromObject((Object)message));
    }

    @Deprecated
    public static UserItem getUserInfo(String accessToken, String openid) throws Exception {
        logger.info("getUserInfo accessToken= {} , openid={}", (Object)accessToken, (Object)openid);
        String url = String.format("https://api.weixin.qq.com/sns/userinfo?access_token=%s&openid=%s&lang=zh_CN", accessToken, openid);
        String message = WeiXinHttpUtil.doGet(url);
        logger.info(message);
        return new UserItem(JSONObject.fromObject((Object)message));
    }

    public static boolean access(String token, String signature, String timestamp, String nonce) {
        if (logger.isInfoEnabled()) {
            logger.info("access checkSignature");
            logger.info("\t\t\tsignature=" + signature);
            logger.info("\t\t\ttimestamp=" + timestamp);
            logger.info("\t\t\tnonce=" + nonce);
        }
        ArrayList<String> ss = new ArrayList<String>();
        ss.add(timestamp);
        ss.add(nonce);
        ss.add(token);
        Collections.sort(ss);
        StringBuilder builder = new StringBuilder();
        for (String s : ss) {
            builder.append(s);
        }
        return signature.equalsIgnoreCase(HashKitUtil.sha1(builder.toString()));
    }

    public static WxRecvMsg recv(InputStream in) throws JDOMException, IOException {
        if (logger.isInfoEnabled()) {
            logger.info("recv in is not null?" + (in != null));
        }
        return WxMsgKit.parse(in);
    }

    public static void send(WxSendMsg msg, OutputStream out) throws JDOMException, IOException {
        Document doc;
        if (logger.isInfoEnabled()) {
            logger.info("send msg=" + msg);
        }
        if (null != (doc = WxMsgKit.parse(msg))) {
            new XMLOutputter().output(doc, out);
        } else if (logger.isInfoEnabled()) {
            logger.info("\u53d1\u9001\u6d88\u606f\u65f6,\u89e3\u6790\u51fadom\u4e3a\u7a7a msg :" + msg);
        }
    }

    public static WxSendMsg builderSendByRecv(WxRecvMsg msg) {
        if (logger.isInfoEnabled()) {
            logger.info("builderSendByRecv msg=" + msg);
        }
        WxRecvMsg m = new WxRecvMsg(msg);
        String from = m.getFromUser();
        m.setFromUser(m.getToUser());
        m.setToUser(from);
        m.setCreateDt(String.valueOf(System.currentTimeMillis() / 1000L));
        return new WxSendMsg(m);
    }

    public static Map<String, String> xmlToMap(String strXML) throws Exception {
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream stream = new ByteArrayInputStream(strXML.getBytes("UTF-8"));
            org.w3c.dom.Document doc = documentBuilder.parse(stream);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getDocumentElement().getChildNodes();
            for (int idx = 0; idx < nodeList.getLength(); ++idx) {
                Node node = nodeList.item(idx);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                data.put(element.getNodeName(), element.getTextContent());
            }
            try {
                ((InputStream)stream).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return data;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error("Invalid XML, can not convert to map. Error message: {}. XML content: {}", (Object)ex.getMessage(), (Object)strXML);
            throw ex;
        }
    }

    public static String beanToString(Object obj) {
        return JSONObject.fromObject((Object)obj).toString();
    }

    public static String mapToXml(Map<String, String> data) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        org.w3c.dom.Document document = documentBuilder.newDocument();
        Element root = document.createElement("xml");
        document.appendChild(root);
        for (String key : data.keySet()) {
            String value = data.get(key);
            if (value == null) {
                value = "";
            }
            value = value.trim();
            Element filed = document.createElement(key);
            filed.appendChild(document.createTextNode(value));
            root.appendChild(filed);
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        DOMSource source = new DOMSource(document);
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
        String output = writer.getBuffer().toString();
        try {
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return output;
    }

    public static void main(String[] args) {
        String access_token = WeiXin.getAccess_token("wx0572556c5a8e9d1f", "3d95218e6327d1fcea82bc045f48c4aa");
        System.out.println(access_token);
        ExpressTemplate template = new ExpressTemplate();
        template.setAccessToken(access_token);
        template.setOpenId("oxOcOwFkz4vbmBN3tGI65PwZr8Z0");
        template.setDecript("\u5feb\u9012\u5df2\u57289\u670820\u53f7\u4ece\u676d\u5dde\u53d1\u51fa");
        template.setExpressGoods("iphone xxx");
        template.setExpressName("\u987a\u6c34\u5feb\u9012");
        template.setExpressNO("2220438sb12311212231");
        template.setRemark("\u9884\u8ba13\u5929\u5185\u5230\u8fbe\uff0c\u6ce8\u610f\u7b7e\u6536");
        template.setSendDate("2018-09-20");
        template.setJumpUrl("www.baidu.com");
        template.setTemplateId("kAX8K5B6BVVC21LGV9o_cmv9nlWgJ4_tbYK-Vl7K51o");
        try {
            System.out.println(WeChatTemplate.sendTemlate(template));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

