package cn.smarthse.modules.health.service.work.trusteeship;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipServiceOrgInfo;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipAllowReasonParam;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipAppStatisticsVo;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipOrgParam;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipServiceOrgModel;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * 《托管定时器任务-托管企业服务数量》
 *
 * @author 吴嘉诚
 * @Project: smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2022/4/15 16:28
 */
public interface ITrusteeshipServiceOrgInfoService extends IBaseService<TrusteeshipServiceOrgInfo> {

    /**
     * 根据负责地区ID，年份，季度，查询需服务企业数 和 已服务企业数
     *
     * @param areaId
     * @param year
     * @param quarter
     * @return
     */
    TrusteeshipServiceOrgInfo selectOne(Long areaId, Integer year, Integer quarter);

    /**
     * 根据年度和托管机构id来查询第三方托管服务信息
     *
     * @param jParam
     * @param trusteeshipOrgId
     * @param year
     * @return
     */
    PageInfo<TrusteeshipServiceOrgInfo> selectList(JqGridParam jParam, Long trusteeshipOrgId, Integer year);

    /**
     * 是否允许批量补录
     *
     * @param param
     * @return
     */
    boolean changeStatus(TrusteeshipAllowReasonParam param);

    /**
     * 年度第三方托管服务机构列表
     * 根据页面点击链接不同，查看对应的年度、季度、机构完成或未完成
     *
     * @param param
     * @return
     */
    List<TrusteeshipServiceOrgModel> queryListByOrgParam(TrusteeshipOrgParam param);

    /**
     * 年度第三方托管服务机构列表分页查询
     * @param jParam
     * @param param
     * @return
     */
    PageInfo<TrusteeshipServiceOrgModel> queryListPageByOrgParam(JqGridParam jParam, TrusteeshipOrgParam param);

    /**
     * 根据机构id，年份，季度，查询需服务企业数 和 已服务企业数
     *
     * @param orgId
     * @param year
     * @param quarter
     * @return
     */
    TrusteeshipServiceOrgInfo selectOneInfoByOrgId(Long orgId, Integer year, Integer quarter);

    /**
     * 服务记录年度统计
     * 展示本托管服务机构按年度统计的每个周期的服务记录
     *
     * @param orgId
     * @param year
     * @return
     */
    List<TrusteeshipAppStatisticsVo> getAnnualStatistics(Long orgId, Integer year);

    /**
     * @Comments:  <第三方托管定时任务>
     *      每个季度最后一个月的25号24点对本周期的工作状态进行更新；
     *      cron : 0 0 0 26 3,6,9,12 ?
     * @author 吴嘉诚
     * @since 2022/4/15
     */
    void endOfQuarterlyStatisticsTask();

    /**
     * @Comments:  <第三方托管定时任务>
     *      每个季度第一个月的第一天0点将本周期的状态从未开始变成进行中；
     *      cron : 0 0 0 1 1,4,7,10 ?
     * @author 吴嘉诚
     * @since 2022/4/15
     */
    void statusChanges();

    /**
     *  查询对应机构、对应负责地区、对应年份和季度的第三方托管服务机构工作信息
     * @param trusteeshipOrgId
     * @param areaId
     * @param year
     * @param quarter
     * @return
     */
    TrusteeshipServiceOrgInfo selectOneInfoByOrgIdAndAreaId(Long trusteeshipOrgId, Long areaId, Integer year, Integer quarter);

    /**
     * 批量新增
     * @param list
     * @return
     */
    Integer insertBatch(List<TrusteeshipServiceOrgInfo> list);

}
