package cn.smarthse.modules.health.service.work.trusteeship;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipRisk;

/**
 * @author ShenZQ
 * @since 2022-04-27 14:03
 */
public interface ITrusteeshipRiskService extends IBaseService<TrusteeshipRisk> {

    /**
     * 发送预警信息（经营状态相关）
     *
     * @param trusteeshipInfoId
     * @param status
     */
    boolean sendWarnInformation(Long trusteeshipInfoId, Integer status);

    /**
     * 是否已确认
     *
     * @param trusteeshipInfoId
     * @param status
     * @return
     */
    int isConfirm(Long trusteeshipInfoId, Integer status);
}
