package cn.smarthse.modules.health.service.work.trusteeship;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipOrg;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipCompanyVo;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * 《托管机构接口》
 *
 * @author XiaoYi(肖奕)
 * @Project: smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2022年4月11日-下午1:28:23
 */
public interface ITrusteeshipOrgService extends IBaseService<TrusteeshipOrg> {

    /**
     * 根据 托管机构名 和 核查企业名 获取该托管机构所在服务区域内的所有企业列表
     *
     * @param companyName
     * @param orgName
     * @return
     */
    PageInfo<TrusteeshipCompanyVo> getCompanyList(JqGridParam jParam, String companyName, String orgName);

    /**
     * 根据区域ID查询第三方托管机构
     *
     * @param areaId
     * @return
     */
    TrusteeshipOrg getByAreaId(Long areaId);

    /**
     * 是否提供托管服务
     *
     * @param cid
     * @return
     */
    TrusteeshipOrg getTrusteeshipService(Long cid, Byte type);

    TrusteeshipOrg getByOrgId(Long orgId, Integer year);

    TrusteeshipOrg getByOrgId(Long orgId);

    /**
     * 根据机构id或企业id查询托管机构信息
     *
     * @param orgId
     * @param type
     * @return
     */
    TrusteeshipOrg getTrusteeshipIdByTypeAndId(Long orgId, Integer type);

    /**
     * 判断某个企业是否是被某个托管机构实施的
     *
     * @param orgName
     * @param cid
     * @return
     */
    boolean isTrusteeship(String orgName, Long cid);

    /**
     * @Comments: <第三方托管定时任务>
     * 需服务企业：每个月1号0点计算需要服务的企业数（该辖区内，正常营业+暂停营业的企业数）
     * cron : 0 0 0 1 * ?
     * @author 吴嘉诚
     * @since 2022/4/15
     */
    void statisticsTask();

    /**
     * 获取所有托管机构信息
     *
     * @return
     */
    List<TrusteeshipOrg> getAllTrusteeshipOrg();

    /**
     * 为新增加企业生成第三方托管服务机构工作信息、托管核查工作信息和托管核查工作详情
     *
     * @param org
     */
    void createDataForNewTrusteeshipOrg(TrusteeshipOrg org);

    /**
     * 添加托管机构
     *      只能选择一个负责区域
     * @param org
     * @param loginUserId
     */
    void addNewTrusteeshipOrg(Long loginUserId, TrusteeshipOrg org);

    /**
     * 根据 托管机构名 和 核查企业名 获取该托管机构所在服务区域内的所有企业列表(只含被退回和数据补录)
     *
     * @param companyName
     * @param orgName
     * @return
     */
    PageInfo<TrusteeshipCompanyVo> getLastCompanyList(JqGridParam jParam, String companyName, String orgName);

    /**
     * 第三方托管测试 - 生成指定年份和季度的托管数据
     * @param year
     * @param quarter
     */
    void createTrusteeshipInfosByYearAndQuarter(Integer year, Integer quarter);
}
