package cn.smarthse.modules.health.service.work.trusteeship;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipManager;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipInfoParam;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipManagerModel;
import com.github.pagehelper.PageInfo;

/**
 * 第三方托管服务管理档案
 * @author 吴嘉诚
 * @date 2022/6/8 12:46
 * @desc
 */
public interface ITrusteeshipManagerService {

    /**
     * 第三方托管服务管理档案
     * 查看辖区内各年度第三方托管服务工作开展情况
     *
     * @param param
     * @return
     */
    PageInfo<TrusteeshipManager> getManagerData(TrusteeshipInfoParam param, JqGridParam jparam);

    /**
     * 第三方托管服务管理档案定时任务
     *      每年的12月25日生成下一年的托管服务管理档案数据
     */
    void createYearOfTrusteeshipManager();

    /**
     * 第三方托管服务管理档案定时任务
     *      生成当年的托管服务管理档案数据
     */
    void createCurrYearOfTrusteeshipManager();
}
