/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.trusteeship;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipInfo;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipOrg;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipServiceOrgInfo;
import cn.smarthse.modules.health.vo.work.trusteeship.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * 《托管核查信息接口》
 *
 * @author XiaoYi(肖奕)
 * @Project: smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2022年4月11日-下午1:28:23
 */
public interface ITrusteeshipInfoService extends IBaseService<TrusteeshipInfo> {

    /**
     * 根据年度、季度、存在待整改、存在待验收、托管机构名称查询第三方托管核查工作列表
     *      包含整改信息
     * @param trusteeshipInfoParam
     * @return
     */
    PageInfo<TrusteeshipInfoVo> getTrusteeshipList(JqGridParam param, TrusteeshipInfoParam trusteeshipInfoParam);

    /**
     * 根据年度、季度、存在待整改、存在待验收、托管机构名称查询第三方托管核查工作列表
     *      不包含整改信息
     * @param trusteeshipInfoParam
     * @return
     */
    PageInfo<TrusteeshipInfoVo> getTrusteeshipPagingQuery(JqGridParam param, TrusteeshipInfoParam trusteeshipInfoParam);

    TrusteeshipInfo getDetailInfoById(Long id);


    /**
     * 根据ID获取 第三方托管核查工作详情
     *
     * @param id
     * @return
     */
    TrusteeshipInfoQueryVo getTrusteeshipInfoVoById(Long id);

    /**
     * 第三方托管服务管理档案
     * 查看辖区内各年度第三方托管服务工作开展情况
     *
     * @param param
     * @return
     */
    PageInfo<TrusteeshipManagerModel> getManagerData(TrusteeshipInfoParam param, JqGridParam jparam);

    /**
     * 用人单位托管核查工作列表（只含正常）
     *
     * @param cid
     * @param tab  0:代办 1:已完成
     * @param year
     * @return
     */
    List<TrusteeshipCheckedVo> getCheckWorkList(Long cid, Integer tab, Integer year, String orgName);

    /**
     * 风险预警列表
     *
     * @param jParam
     * @param searchVo
     * @return
     */
    PageInfo<RiskWarningVo> getWarningList(JqGridParam jParam, RiskWarningParam searchVo);

    /**
     * 风险预警状态更新
     *
     * @param trusteeshipInfoId 托管核查工作信息id
     * @param cid               企业id
     * @param riskWarningType   风险预警类型
     * @param status            0:确定 1:未关闭 2:未暂停
     * @return 0:无效操作 1:操作成功
     */
    Boolean updateStatus(Long trusteeshipInfoId, Long cid, Integer riskWarningType, Integer status);

    /**
     * 查看该机构某个年度为某企业实施的第三方托管服务工作详情
     *
     * @param realCid 真正的企业id
     * @param cid     企业id 或 机构id
     * @param i       代表cid属于什么  1:企业 2:机构
     * @return
     */
    List<TrusteeshipInfoThirdVo> getTrusteeshipInfoVoListById(Long realCid, Long cid, int i, Integer year);

    /**
     * @ Description: <获取待补录核查工作数量:状态为退回和数据补录的>
     * @ Author XiaoYi
     * @ Date  2022/4/21  9:00
     * @ param
     * @ return
     **/
    Integer getRecordingNumByOrg(Long orgId, Integer year, Integer quarter);

    /**
     * 根据cid、年、季度查询托管核查工作信息
     *
     * @param cid
     * @param year
     * @param quarter
     * @return
     */
    TrusteeshipInfo getByCidAndYearQuarter(Long cid, int year, int quarter);

    /**
     * 获取该托管机构所服务的所有未完成的企业di
     *
     * @param param
     * @return
     */
    List<Long> selectAllNoCompletedCompanyByTrusteeship(TrusteeshipAllowReasonParam param);

    /**
     * 根据核查机构id、年份、季度 修改状态
     *
     * @param cidList
     * @param year
     * @param quarter
     * @param reason
     * @return
     */
    int changeStatus(List<Long> cidList, Integer year, Integer quarter, byte b, String reason);

    /**
     * 批量插入
     *
     * @param list
     * @return
     */
    Integer insertBatch(List<TrusteeshipInfo> list);

    /**
     * 修改托管核查工作信息的当前年季度的状态
     * @param infoList  需要修改的数据集
     * @param infoStatus    需要修改成为的状态
     */
    void updateBatchToStatusChanges(List<TrusteeshipInfo> infoList, Integer infoStatus);


    void deleteReformInfoByTrusteeshipInfoId(Long trusteeshipInfoId);

    /**
     * 根据负责区域ID获取指定状态托管核查工作信息数
     * @return
     */
    Integer getFinishedInfoGroupByAreaId(TrusteeshipServiceOrgInfo orgInfo, Byte areaLevel, Byte status);

    /**
     * 变更行政区划后更新托管核查工作信息
     * @param trusteeshipOrgAfter
     * @param trusteeshipOrgBefore
     * @param cid
     * @param loginStaffId
     * @param afterAreaId
     * @param beforeAreaId
     */
    void updateForChangeTrusteeshipOrg(TrusteeshipOrg trusteeshipOrgAfter, TrusteeshipOrg trusteeshipOrgBefore,
                                       Long cid, Long loginStaffId, Long afterAreaId, Long beforeAreaId);

}
