/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.trusteeship;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipInfoDetail;
import cn.smarthse.modules.health.vo.work.trusteeship.TrusteeshipInfoDetailQueryVo;

import java.util.List;

/**
 * 《托管核查详情接口》
 *
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @author XiaoYi(肖奕) 
 * @since 2022年4月11日-下午1:28:23
 */
public interface ITrusteeshipInfoDetailService extends IBaseService<TrusteeshipInfoDetail> {

     List<TrusteeshipInfoDetail> getDetailListByTrusteeshipId(Long trusteeshipId);


     Integer getUnregisteredNum(Long trusteeshipId);

 /**
  *@ Description: <获取隐患草稿数量>
  *@ Author XiaoYi
  *@ Date  2022/6/9  8:48
  *@ param
  *@ return
 **/
    Integer getReformDraftNum(Long trusteeshipId);

    /**
     * 根据 托管核查信息ID 查询 托管核查工作详情列表
     * @param id
     * @return
     */
    List<TrusteeshipInfoDetail> getByInfoId(Long id);

    /**
     * 核查表详情查看
     * @param id
     * @return
     */
    TrusteeshipInfoDetailQueryVo getDetailQueryVoByInfoId(Long id);


    /**
     *@ Description: <获取待整改项目数量>
     *@ Author XiaoYi
     *@ Date  2022/4/12  19:01
     *@ param
     *@ return
     **/
    Integer getTobeReformNum(Long trusteeshipId);

    /**
     *@ Description: <获取待验收项目数量>
     *@ Author XiaoYi
     *@ Date  2022/4/12  19:01
     *@ param
     *@ return
     **/
    Integer getTobeAcceNum(Long trusteeshipId);

    /**
     * 批量添加详情
     * @param list
     * @return
     */
    Integer insertBatch(List<TrusteeshipInfoDetail> list);


    void deleteReformInfoByDetailId(Long detailId);

   /**
    * 获取托管核查项目总项数
    * @return
    */
   int getItemsTotalNum();

    /**
     * 为所有托管核查工作信息添加指定的一个或多个托管核查工作详情（若已经存在不会重复添加）
     * @param itemNo    需要添加的项目编号
     * @return
     */
    void addDetailsForInfo(Long itemNo);

    /**
     * 逻辑批量删除
     * @param infoDetailList
     */
    void logicDelete(List<TrusteeshipInfoDetail> infoDetailList, Long loginStaffId);
}
