/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.train;

import java.util.List;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.train.TrainSummarize;



 /**
 * 
 * 《TrainSummarizeService》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <年度培训总结>
 * @JDK version used:      <JDK1.7> 
 * @author xiaoyi（肖奕）
 * @since 2017-06-16 10:07
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface ITrainSummarizeService extends IBaseService<TrainSummarize>{

	PageInfo<TrainSummarize> getFinishedList(JqGridParam param);

	PageInfo<TrainSummarize> getUnFinishedList(JqGridParam param);

	List<TrainSummarize> getFinishedByCid(Long cid);

	TrainSummarize updateAndFile(TrainSummarize info, Long staffid);

	TrainSummarize addAndFile(TrainSummarize info, Long staffid, Long cid);

	TrainSummarize getByIdWithFile(Long id);

	//根据企业id统计未完成的教年度培训总结
	int getUnFinishedNum(Long cid);
	
	/**
	 * 根据企业cid统计已完成的培训总结数目
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年9月28日-下午3:28:39
	 * @param cid
	 * @return
	 */
	int getFinishedNum(Long cid);
	//判断某年是否有年度培训总结记录
	Boolean  haveTrainThisYear(Long cid,Integer year);
	//获取某年最早的年度培训总结记录
	TrainSummarize getEarliestTrain(Long cid,Integer year);
	//判断是否出现添加年度培训总结提示
	Boolean haveTrainSummarize(Long cid,Integer year);

	/**
	 * 作废
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2018年4月10日-下午3:08:46
	 * @param id
	 * @param staffid
	 */
	//void toVoid(Long id, Long staffid);
}
