package cn.smarthse.modules.health.service.work.train;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.common.model.PageParamModel;
import cn.smarthse.modules.health.entity.work.train.*;
import cn.smarthse.modules.health.model.HTrainingDetailInfoModel;
import cn.smarthse.modules.health.model.HTrainingDetailModel;
import cn.smarthse.modules.health.model.HTrainingModel;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearWorkService;
import cn.smarthse.modules.health.vo.summary.BaseSummaryVO;
import cn.smarthse.modules.health.vo.work.judge.TrainEducationInfo;
import cn.smarthse.modules.health.vo.work.train.OutTrainInfoVo;
import cn.smarthse.modules.health.vo.work.train.TrainPlanCountView;
import cn.smarthse.modules.health.vo.work.train.TrainWorkItemVo;
import cn.smarthse.modules.training.model.HealthTalentPointsModel;
import com.github.pagehelper.PageInfo;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 《xxxService》
 *
 * @author xiaoyi（肖奕）
 * @Project: GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <培训计划登记>
 * @JDK version used:      <JDK1.7>
 * @since 2017-06-16 10:05
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface ITrainPlanService extends IBaseService<TrainPlan>, IPlanYearWorkService {

    TrainPlan updateAllInfo(TrainPlan info, Long staffid);

    TrainPlan addAllInfo(TrainPlan info, Long staffid, Long cid);

    TrainPlan getByIdWithAllInfo(Long id);

    //获取未完成列表
    PageInfo<TrainPlan> getUnFinishedList(JqGridParam param, String hsType, Integer year);

    //获取已完成列表
    PageInfo<TrainPlan> getFinishedList(JqGridParam param, TrainPlan info);

    //获取已完成列表（不分页）
    List<TrainPlan> getFinishedListNoPage(TrainPlan info);

    //根据企业id统计未完成的教育培训工作数
    int getUnFinishedNum(Long cid);

    //根据企业id统计已完成的教育培训工作数
    int getFinishedNum(Long cid);

    //判断某年是否有培训记录
    Boolean haveTrainThisYear(Long cid, Integer year);

    //判断某年是否有职业卫生培训记录
    Boolean haveOccTrainThisYear(Long cid, Integer year);

    //获取某年最早的培训记录
    TrainPlan getEarliestTrain(Long cid, Integer year);

    //判断是否出现培训提示
    Boolean haveTrain(Long cid, Integer year);

    /**
     * 根据人员获取人员的培训情况
     *
     * @param gparam
     * @param param
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author XiaoYi(肖奕)
     * @since 2017年8月25日-下午4:17:19
     */
    PageInfo<StaffTrainInfo> getStaffTrainInfo(JqGridParam gparam, QueryTrainParam param);

    /**
     * 获取待办事项
     *
     * @param cid
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author XiaoYi(肖奕)
     * @since 2017年8月25日-下午4:16:32
     */
    TrainWorkItemVo getTrainToDoVoInfo(Long cid);

    /**
     * 逻辑删除
     *
     * @param info
     * @param staffid
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author XiaoYi(肖奕)
     * @since 2017年8月28日-下午5:42:55
     */
    void logicDelete(TrainPlan info, Long staffid);

    /**
     * 根据年度获取已完成培训情况
     *
     * @param cid
     * @param year
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author XiaoYi(肖奕)
     * @since 2017年9月20日-下午4:12:26
     */
    TrainPlanSummary getTrainSumm(Long cid, String year);

    /**
     * 根据年度查询汇总结果接口
     *
     * @param cid
     * @param year
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author XiaoYi(肖奕)
     * @since 2017年9月1日-下午4:30:18
     */
    BaseSummaryVO getSummaryData(Long cid, String year);

    //档案3导出word扩充下划线
    String addString(String str);

    /**
     * 微信端获取培训信息接口
     *
     * @param paramModel
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author XiaoYi(肖奕)
     * @since 2017年12月29日-上午9:16:32
     */
    PageInfo<HTrainingModel> getTrainingPage(PageParamModel paramModel);

    /**
     * @ Description: <在线培训信息接口>
     * @ Author XiaoYi
     * @ Date  2022/2/9  14:48
     * @ param
     * @ return
     **/
    PageInfo<HTrainingDetailModel> getTrainingPageInfo(PageParamModel paramModel);

    /**
     * 作废
     *
     * @param id
     * @param staffid
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author XiaoYi（肖奕)
     * @since 2018年4月10日-下午3:02:01
     */
    void toVoid(Long id, Long staffid);

    /**
     * 获取上岗和在岗期间培训信息
     *
     * @param cid
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author XiaoYi（肖奕)
     * @since 2018年8月1日-上午9:28:45
     */
    TrainEducationInfo getTrainEducationInfo(Long cid);

    /**
     * @Description:获取接触危害因素培训人员数量
     * @Author: XiaoYi(肖奕)
     * @Date: 2020/10/15 13:38
     * @param: [cid, year]
     * @return: java.lang.Integer
     **/
    Integer getcontactHarmTrainNumByCid(Long cid, Integer year);

    List<TrainPlan> listOfOccTrainPlan(Map<String, Object> params);

    List<TrainPlan> needOnlineTrainList(Long cid, Long trainStaffId);

    PageInfo<TrainAttend> trainAttendsData(JqGridParam param, Long trainId);

    List<OutTrainInfoVo> getOutTrainInfo(TrainPlan info);

    /**
     * @param
     * @return
     * @Description: 浙江省项目 培训可视化接口
     * @Author XiaoYi
     * @Date 2021/9/24  9:55
     **/
    TrainPlanCountView getTrainPlanCountView(Long cid);

    List<TrainPlan> getTrainByYear(Long cid, Integer year);

    /**
     * @ Description: <对此方法的描述>
     * @ Author XiaoYi
     * @ Date  2022/2/28  10:59
     * @ param
     * @ return
     **/
    List<TrainPlan> getOnWorkTrainByCid(Long cid, Integer year);

    /**
     * 获得考试状态  1-及格，2-不及格，3-未考试
     *
     * @param trainId
     * @param staffId
     * @param cid
     * @return
     */
    Integer isPass(Long trainId, Long staffId, Long cid);

    List<HealthTalentPointsModel> getHealthTalentPointsModelsByCid(Long cid);

    PageInfo<HealthTalentPointsModel> getHealthTalentPointsModelsPageByCid(Integer pageNum, Integer pageSize, Long cid);

    HTrainingDetailInfoModel getOnlineTrainInfoDetail(Long trainId, Long staffId);

    Date getLastOnWorkTrainTime(Long cid);

    public Date getFirstOnWorkTrainTimeByYear(Long cid, Integer year);

    int getFinishedTrainPlanCount(Long cid);

    /**
     * 按时间统计培训人数
     * @param serach 搜索年份
     * @return
     */
    List<Month> getTrainNumByTime(Integer serach,Long cid);

    Integer getTrainStaffNumByYear(Integer year,Long cid);


    TrainPlan getTrainInfoByCidAndReportId(Long cid,Long reportId);

    TrainPlan getByCidAndReportId(Long cid, Long id);

    void updateStatusByReportIdAndCid(TrainPlan trainPlan);

    /**
     * 根据企业ID 或 培训ID查询企业报名信息（都为null查全部）
     * @param reportId
     * @return
     */
    List<TrainPlan> getListByCidOrReportId(Long cid, Long reportId);
}
