package cn.smarthse.modules.health.service.work.train;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.train.TrainPlanExamUserAnswer;
import cn.smarthse.modules.health.pojo.train.AnswerSaveResult;
import cn.smarthse.modules.health.pojo.train.TrainPlanExamUserAnswerDto;

/**
 * @author 邓力宾
 * @date 2022-02-08 10:20
 * @desc
 */
public interface ITrainPlanExamUserAnswerService extends IBaseService<TrainPlanExamUserAnswer> {


    /**
     * 保存用户答案 并计算得分
     * @param userAnswerDto
     */
    AnswerSaveResult saveAnswers(TrainPlanExamUserAnswerDto userAnswerDto);

    /**
     * 最新的考试详情
     * @param trainId 培训id
     * @return
     */
    AnswerSaveResult currentExamDetail(Long trainId, Long staffId);

    /**
     * 根据id查询考试详情
     * @param id
     * @return
     */
    AnswerSaveResult examDetailById(Long id);
}
