package cn.smarthse.modules.health.service.work.train;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.train.TrainPlanExamRecord;
import com.github.pagehelper.PageInfo;

/**
 * @author 邓力宾
 * @date 2022/2/8 14:02
 * @desc
 */
public interface ITrainPlanExamRecordService extends IBaseService<TrainPlanExamRecord> {


    /**
     * 考试记录
     * @param jqGridParam
     * @param staffId
     * @param trainId
     * @return
     */
    PageInfo<TrainPlanExamRecord> queryPage(JqGridParam jqGridParam, Long staffId, Long trainId);

    /**
     * 移除
     * @param trainId
     * @param staffId
     */
    void removeOld(Long trainId, Long staffId);

    /**
     * 查询
     * @param trainId
     * @param staffId
     * @return
     */
    TrainPlanExamRecord getByTrainId(Long trainId, Long staffId);
}
