package cn.smarthse.modules.health.service.work.train;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.train.QueryTrainParam;
import cn.smarthse.modules.health.entity.work.train.StaffTrainInfo;
import cn.smarthse.modules.health.entity.work.train.TrainAttend;
import cn.smarthse.modules.health.entity.work.train.TrainAttendCountModel;
import cn.smarthse.modules.health.model.HTrainingModel;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * 《TrainAttendService》
 *
 * @author xiaoyi(肖奕)
 * @Project: GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <培训参与人员>
 * @JDK version used:      <JDK1.7>
 * @since 2017-06-16 10:03
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface ITrainAttendService extends IBaseService<TrainAttend> {

    /**
     * 根据培训id获取参与人员列表
     *
     * @param id
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author XiaoYi(肖奕)
     * @since 2017年8月11日-下午3:12:33
     */
    List<TrainAttend> getByTid(Long id);

    /**
     * 获取人员培训信息
     *
     * @param param
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author XiaoYi(肖奕)
     * @since 2017年8月11日-下午3:12:53
     */
    List<StaffTrainInfo> getStaffTrainInfo(QueryTrainParam param);

    /**
     * 微信接口获取培训信息
     *
     * @param param
     * @return
     * @Comments: <对此方法的描述，可以引用系统设计中的描述>
     * @author XiaoYi(肖奕)
     * @since 2018年1月3日-上午10:37:34
     */
    List<HTrainingModel> getHTrainingModel(QueryTrainParam param);

    /**
     * 更新考试分数
     *
     * @param staffId    人员id
     * @param trainId    培训id
     * @param score      得分
     * @param examStatus 状态 0:未考试 1:及格 2：不及格
     */
    void updateScore(Long staffId, Long trainId, Integer score, Integer examStatus);

    /**
     * 人员培训记录列表通过StaffId分组
     */
    PageInfo<StaffTrainInfo> getTrainRecordListDataGroupByStaffId(JqGridParam param, QueryTrainParam queryTrainParam);

    /**
     * 人员培训记录列表
     */
    List<StaffTrainInfo> getTrainRecordListData(QueryTrainParam queryTrainParam);


    Integer getTrainStaffNum(QueryTrainParam queryTrainParam);

    TrainAttend getByStaffIdAndTrainId(Long staffId, Long trainPlanId);

    List<TrainAttend> getListByStaffId(Long staffId);

    int batchUpdateStaffName(List<TrainAttend> trainAttendList, String staffName);

    /**
     * 人员培训记录列表通过StaffId分组
     */
    PageInfo<TrainAttendCountModel> getTrainAttendListByDept(JqGridParam param, Long trainId,Boolean isTrain);

     /** 
      *@ Description: <添加未参与培训人员信息>
      *@ Author XiaoYi
      *@ Date  2022/11/28  14:49
      *@ param 
      *@ return 
     **/
    void andUnTrainAttendInfo(Long trainId);
}
