/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.train;

import java.util.List;

import cn.smarthse.modules.health.entity.work.certificate.CertificateStaffDetail;
import cn.smarthse.modules.health.entity.work.train.TrainAttend;
import cn.smarthse.modules.health.entity.work.train.TrainPlan;
import cn.smarthse.modules.health.entity.work.train.TrainSummarize;

/**
 * 《》
 * 培训档案接口
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author XiaoYi(肖奕) 
 * @since 2017年8月30日-下午1:28:23
 */
public interface ITrainArchiveService {
	/**
	 * 获取年度职业卫生培训计划
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年10月11日-下午2:43:37
	 * @param cid
	 * @param year
	 * @return
	 */
	List<TrainPlan> getOccHealthTrainPlanByYear(Long cid,Integer year); 
	/**
	 * 获取年度职业卫生培训列表
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年8月30日-下午2:43:37
	 * @param cid
	 * @param year
	 * @return
	 */
	List<TrainPlan> getOccHealthTrainByYear(Long cid,Integer year);
	
	/**
	 * 获取企业负责人，职业卫生管理人员职业卫生培训证明
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年8月30日-下午2:55:10
	 * @param cid
	 * @param year
	 * @return
	 */
	List<CertificateStaffDetail> getManagerCertByYear(Long cid,Integer year);
	
	/**
	 * 获取年度培训总结记录
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年8月30日-下午5:43:45
	 * @param cid
	 * @param year
	 * @return
	 */
	List<TrainSummarize> getTrainSummarizeByYear(Long cid,Integer year);
	
	/**
	 * 获取参加培训的部门
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author XiaoYi(肖奕) 
	 * @since 2017年8月31日-下午1:56:46
	 * @param cid
	 * @param tid
	 * @return
	 */
	List<TrainAttend> getAttendTrainDept(Long cid,Long tid);
	
	
	/**
	 * 获取培训预览列表
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author  XiaoYi（肖奕)
	 * @since 2019年1月4日-下午4:16:56
	 * @param cid
	 * @param valueOf
	 * @return
	 */
	List<TrainPlan> getOccHealthTrainByYearPre(Long cid, Integer valueOf);

	
}
