/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.thirdtime.simple;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.Company;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.work.thirdtime.TsProjectSimple;
import cn.smarthse.common.framework.database.persistence.LayUiResponseResult;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.param.threeTime.EditParam;
import cn.smarthse.modules.health.pojo.ComplianceTsProjectCount;
import cn.smarthse.modules.health.pojo.self.TsProjectInfo;
import cn.smarthse.modules.health.supervise.service.keyFactory.IApprovalDataSourceService;
import com.github.pagehelper.PageInfo;

import java.util.Date;
import java.util.List;
import java.util.Map;


/**
*
* 《TsProjectSimple》
*
*
* @Project:  GIIANTECH CORE
* @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
* @Comments:  <对此类的描述，可以引用系统设计中的描述>
* @JDK version used:      <JDK1.7>
* @author wujiacheng
* @since 2022-7-25
*/

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface ITsProjectSimpleService extends IBaseService<TsProjectSimple> , IApprovalDataSourceService {

   /**
    *
    * @Comments:  <获取 三同时的数据列表， 带分页项>
    * @author wujiacheng
    * @since 2022-7-25
    * @param param
    * @return
    * @throws Exception
    */
   PageInfo<TsProjectSimple> pageTsProjectSimple(JqGridParam param, Integer year, Byte type) ;

   /**
    * @Comments:  根据对象是否有主键id 判断做更新还是创建操作
    * @author wujiacheng
    * @since 2022-7-25
    * @param tsProjectSimple
    * @param loginStaffId
    * @param cid
    * @return
    * @throws Exception
    */
   public TsProjectSimple saveOrUpdateTsProject(TsProjectSimple tsProjectSimple, Long loginStaffId, Long cid) throws Exception;

   /**
    * @Comments:  <删除 >
    * @author wujiacheng
    * @since 2022-7-25
    * @param tsProjectSimple
    * @param loginStaffId
    */
   public void delTsProject(TsProjectSimple tsProjectSimple, Long loginStaffId) throws Exception;

   /**
    * 可视化 - 预评次数 控评次数 职业病防护次数
    */
   Map<String, Map<Integer, Integer>> getCountForVisualize(Long cid);

   /**
    * V3.2.2.1 三同时列表
    * @param param
    * @param status
    * @return
    */
   LayUiResponseResult<TsProjectSimple> pageList(SearchParam param);
   List<TsProjectSimple> list(SearchParam param);

   /**
    * 同步isr上的数据
    * @param cid
    */
   void syncData(Long cid);

   /**
    * 删除irs上已经被删除的数据
    * @param cid
    */
   void deleteSyncData(Long cid);

   TsProjectInfo getFinishAndTotalNum(Long cid);

   /**
    * 项目终止
    * @param dbData
    * @param currentCompany
    * @param loginStaff
    */
    void close(TsProjectSimple dbData, Company currentCompany, StaffInfo loginStaff);

   /**
    * 查询企业已终止的三同时数量
    * @param cid
    * @return
    */
   int countClosedNum(Long cid);

   /**
    * 查询最近两年的项目数量
    * @param cid
    * @return
    */
   int countLast2YearNum(Long cid);

   /**
    * 通过id查询详情（包括文件等）
    * @param id
    * @return
    */
    TsProjectSimple getDetailById(Long id);

   TsProjectSimple saveInfo(TsProjectSimple tsProjectSimple, EditParam param) throws Exception;

   /**
    * 监管单点登录后退回到草稿状态接口
    * @param id
    * @param loginStaffId
    * @param superviseFullName
    */
    void superviseBack2Default(Long id, Long loginStaffId, String superviseFullName) throws Exception;

   /**
    * 未完成的数量
    * @param cid
    * @return
    */
   int countUnFinishNum(Long cid);

   /**
    *  查询在某个时间节点前是否有已完成的项目
    * @param cid
    * @param date
    * @return
    */
   Boolean existFinishedProjects(Long cid, Date date);

   /**
    *  将上一年度含有进行中的三同时项目状态置为草稿
    * @param cid 企业id
    */
   void changeLastYearINGProjectStatus(Long cid);

   /**
    * 查询合规企业三同时项目数量
    * @param cids
    * @param recentYears 传入数字几就表示近几年
    * @return
    */
   List<ComplianceTsProjectCount> getComplianceTsProjectCount(List<Long> cids, Integer recentYears);

   /**
    * 通过档案id查询三同时项目信息
    *
    * @param archiveId 档案id
    * @return 三同时项目
    */
   TsProjectSimple getTsProjectSimpleByArchiveId(Long archiveId);

    TsProjectSimple getByProjectCode(String projectCode);

    List<TsProjectSimple> getNewGuideProjectList(List<Long> cidList,Boolean isValid);

   /**
    * 提交新建企业关联的三同时项目
    */
    void submitNewCompanyGuideTsProject(Long projectId, Company company, StaffInfo loginStaff) throws Exception;

    void resetTsProject(Long cid);
}
