/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.thirdtime;

import java.util.List;
import java.util.Map;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.modules.health.vo.outdata.thirdtime.ThirdTimeModel;
import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.thirdtime.TsProject;
import cn.smarthse.modules.health.entity.work.thirdtime.TsProjectUpdable;
import cn.smarthse.modules.health.entity.work.thirdtime.vo.TsProjectFinishForm;
import cn.smarthse.modules.health.entity.work.thirdtime.vo.TsProjectSummaryGridVo;
import cn.smarthse.modules.health.entity.work.thirdtime.vo.TsProjectVo;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearWorkService;
import cn.smarthse.modules.health.vo.summary.BaseSummaryVO;
import cn.smarthse.modules.health.vo.work.judge.ThirdTimeInfo;


 /**
 * 
 * 《TsProject》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @since 2017-07-12 02:20
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface ITsProjectService extends IBaseService<TsProject>,IPlanYearWorkService{

	/**
	 * 
	 * 
	 * @Comments:  根据对象是否有主键id 判断做更新还是创建操作
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017-07-12 02:20
	 * @param TsProject
	 * @param loginStaffId
	 * @param cid
	 * @return
	 * @throws Exception
	 */
	public TsProject saveOrUpdateTsProject(TsProject tsProject, Long loginStaffId,Long cid) throws Exception;
	
	/**
	 * 
	 * 
	 * @Comments:  <强制更新>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年7月14日-上午10:37:43
	 * @param tsProject
	 * @param loginStaffId
	 * @param cid
	 * @return
	 * @throws Exception
	 */
	public int updateTsProject(TsProjectUpdable tsProject, Long loginStaffId) throws Exception;
	
	/**
	 * 
	 * 
	 * @Comments:  <获取 三同时的数据列表， 带分页项>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年7月12日-下午3:20:32
	 * @param param
	 * @return
	 * @throws Exception
	 */
	public PageInfo<TsProjectVo> pageTsProject(JqGridParam param,Boolean finish) ;

	/**
	 * 
	 * 
	 * @Comments:  <保存完成阶段信息内容>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年7月19日-下午5:21:51
	 * @param tspfForm
	 * @param cid
	 * @param loginStaffId
	 * @return
	 * @throws Exception 
	 */
	public Map<String, Object> saveTsProjectOtherFile(TsProjectFinishForm tspfForm, Long cid, Long loginStaffId) throws Exception;
	
	/**
	 * 
	 * 
	 * @Comments:  <统计 三同时工作数量>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年8月30日-下午5:38:13
	 * @param cid
	 * @param isFinish
	 * @return
	 */
	public Integer countTsProjectByCid(Long cid, Boolean isFinish) ;
	
	
	/**
	 * 
	 * 
	 * @Comments:  根据年度统计三同时项目数量
	 * @author gbx
	 * @since 2017-9-5-上午9:15:48
	 * @param cid
	 * @param year
	 * @return
	 */
	BaseSummaryVO getSummaryData(Long cid, String year);
	
	
	/**
	 * 
	 * 
	 * @Comments:  <统计 《职业病危害预评价报告》、《职业病防护设施设计专篇》、《职业病危害控制效果评价报》这三个附件是否存在（以列表形式展示）>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年9月1日-下午4:21:05
	 * @param param
	 * @param year
	 * @return
	 */
	public PageInfo<TsProjectSummaryGridVo> collectTsProjectSummary(Long cid,JqGridParam param, String year);

	/**
	 * 
	 * 
	 * @Comments:  <删除实体数据，并触发首页提示删除动作 >
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年12月27日-上午10:53:03
	 * @param ts
	 * @param loginStaffId
	 */
	public void delTsProject(TsProject ts, Long loginStaffId);
	/**
	 * 
	 * 
	 * @Comments:  <三同时 作废>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2018年4月10日-下午3:08:41
	 * @param ts
	 * @param loginStaffId
	 */
	public void toVoidTsProject(TsProject ts, Long loginStaffId);
	
	public List<TsProjectVo> listTsProjectVo(Long cid,Boolean finish) ;
	/**
	 * 建设项目清单（进行中）（23-002）和“三同时”管理结果统计（23-019）所有列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2018年8月1日-上午11:18:02
	 * @param cid
	 * @return
	 */
	public List<ThirdTimeInfo> getThirdTimeInfo(Long cid) ;
	/**
	 * @Comments:  <简化版三同时信息接口>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2022/4/17-17:19
	 * @param cid
	 * @return java.util.List<cn.smarthse.modules.health.vo.work.judge.ThirdTimeInfo>
	*/
	public List<ThirdTimeInfo> getLiteThirdTimeInfo(Long cid);
	 /**
	  * @Comments:  <获取档案数据>
	  * @author zhoulj(周利军) [1217102780@qq.com]
	  * @since 2018/12/10-10:19
	  * @param cid
	  * @param docParamValue
	  * @return java.util.Map<java.lang.String,java.lang.Object>
	  */
	 Map<String, Object> getDocData(Long cid, String docParamValue);


	 public ResponseData<String> importThirdTimeModel(ThirdTimeModel thirdTimeModel) throws Exception;
}
