/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.thirdtime;

import java.util.List;

import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.base.company.CompanyTechnologyProcess;
import cn.smarthse.modules.health.entity.base.device.DeviceInfo;
import cn.smarthse.modules.health.entity.base.material.vo.MaterialImportVo;
import cn.smarthse.modules.health.entity.base.material.vo.MatterItemVO;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffInfoImportVo;
import cn.smarthse.modules.health.entity.work.thirdtime.TsProjectBasicinfoLink;
import cn.smarthse.modules.health.entity.work.thirdtime.vo.TsBasicBuildVo;
import cn.smarthse.modules.health.entity.work.thirdtime.vo.TsBasicDeviceVo;
import cn.smarthse.modules.health.entity.work.thirdtime.vo.TsBasicManagerVo;
import cn.smarthse.modules.health.entity.work.thirdtime.vo.TsBasicStaffVo;


 /**
 * 
 * 《TsProjectBasicinfoLink》
 * 
 * 
 * @Project:  GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @since 2017-07-12 02:20
 */

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface ITsProjectBasicinfoLinkService extends IBaseService<TsProjectBasicinfoLink>{

	/**
	 * 
	 * 
	 * @Comments:  根据对象是否有主键id 判断做更新还是创建操作
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017-07-12 02:20
	 * @param TsProjectBasicinfoLink
	 * @param loginStaffId
	 * @param cid
	 * @return
	 * @throws Exception
	 */
	public TsProjectBasicinfoLink saveOrUpdateTsProjectBasicinfoLink(TsProjectBasicinfoLink tsProjectBasicinfoLink, Long loginStaffId,Long cid) throws Exception;

	/**
	 * 
	 * 
	 * @Comments:  <获取三同时 项目基础信息的 项目人员信息>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年7月24日-下午2:57:50
	 * @param param
	 * @param cid
	 * @param tsId
	 * @param isThirdPart
	 * @return
	 */
	public PageInfo<TsBasicStaffVo> pageTsprojectStaff(JqGridParam param,Long cid,Long tsId,Boolean isThirdPart);
	
	/**
	 * 
	 * 
	 * @Comments:  <添加 项目基础信息>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年7月24日-下午3:16:39
	 * @param linkIds
	 * @param category 根据不同的 category 添加不同的项目基础新， 如category==1 即是添加项目人员的基本信息
	 * @param tsId
	 * @param loginStaffId
	 * @param cid
	 */
	public void saveBatchBasicInfo(List<Long> linkIds,Byte category,Long tsId, Long loginStaffId,Long cid);
	
	public void saveBatchBasicInfo(Long[] linkIds,Byte category,Long tsId, Long loginStaffId,Long cid) ;

	/**
	 * 
	 * 
	 * @Comments:  <获取 三同时 项目建筑物数据列表>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年7月25日-下午4:12:39
	 * @param param
	 * @param cid
	 * @param tsProjectId
	 * @return
	 */
	public PageInfo<TsBasicBuildVo> pageTsprojectBuild(JqGridParam param, Long cid, Long tsProjectId);
	
	/**
	 * 
	 * 
	 * @Comments:  <获取 三同时 项目工艺流程数据列表>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年8月1日-下午3:02:39
	 * @param param
	 * @param cid
	 * @param tsProjectId
	 * @return
	 */
	public PageInfo<CompanyTechnologyProcess> pageTsprojectGy(JqGridParam param, Long cid, Long tsProjectId) ;
	/**
	 * 
	 * 
	 * @Comments:  <获取 三同时 项目物料数据列表>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年7月26日-下午4:33:13
	 * @param param
	 * @param cid
	 * @param tsProjectId
	 * @return
	 */
	public PageInfo<MatterItemVO> pageTsprojectMatter(JqGridParam param, Long cid, Long tsProjectId,boolean isproduct);

	/**
	 * 
	 * 
	 * @Comments:  <获取 三同时 项目管理制度数据列表>>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年7月27日-下午3:07:11
	 * @param param
	 * @param cid
	 * @param tsProjectId
	 * @return
	 */
	public PageInfo<TsBasicManagerVo> pageTsprojectManager(JqGridParam param, Long cid, Long tsProjectId);
	/**
	 * 
	 * 
	 * @Comments:  <导入  建筑物数据>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年7月25日-下午6:05:44
	 * @param fileId
	 * @param loginStaffId
	 * @param cid
	 */
	public void importBuild(Long fileId,Long tsId,Long loginStaffId, Long cid);
	/**
	 * 
	 * 
	 * @Comments:  <导入人员信息   并添加到三同时 项目基础信息中>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年7月25日-下午6:58:48
	 * @param staffInfoImportVo
	 * @param tsId
	 * @param loginStaffId
	 * @param cid
	 * @return 
	 */
	public void importStaff(StaffInfoImportVo staffInfoImportVo, Long tsId, Long loginStaffId, Long cid);

	public PageInfo<TsBasicDeviceVo> pageTsprojectDevice(JqGridParam param, Long cid, Long tsProjectId);

	/**
	 * 
	 * 
	 * @Comments:  <导入设备设施数据>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年8月15日-下午2:12:08
	 * @param fileId
	 * @param tsId
	 * @param loginStaffId
	 * @param cid
	 */
	public ResponseData<List<DeviceInfo>> importDevice(Long fileId, Long tsId, Long loginStaffId, Long cid);

	/**
	 * 
	 * 
	 * @Comments:  <导入 物料数据>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2017年8月15日-下午2:19:41
	 * @param fileId
	 * @param tsId
	 * @param loginStaffId
	 * @param cid
	 */
	public ResponseData<List<MaterialImportVo>> importMatter(Long fileId, Long tsId, Long loginStaffId, Long cid);
}
