/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.shield;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.shield.ShieldSend;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldSendCount;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldSendTips;
import cn.smarthse.modules.health.vo.work.judge.ShieldSendInfo;
import cn.smarthse.modules.health.vo.work.shield.ShieldSendCountParamVo;
import cn.smarthse.modules.health.vo.work.shield.ShieldSendCountVo;
import com.github.pagehelper.PageInfo;

import java.util.Date;
import java.util.List;


//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IShieldSendService extends IBaseService<ShieldSend> {

	ShieldSend getDetailById(Long id);

	List<ShieldSend> listDetails(ShieldSend data);

	List<ShieldSend> list(ShieldSend data);

	void deleteByIds(String ids, Long staffId,Long cid);

	ShieldSend insertOrUpdate(ShieldSend send, Long cid, Long staffId);

	PageInfo<ShieldSend> getList(JqGridParam gparam, ShieldSend param);

	List<ShieldSendCount> countShieldSend(int distance,Long cid);
	/**
	 * 
	 * @Comments:  获取列表总和
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年7月10日-下午6:14:57
	 * @param cid
	 * @param status
	 * @return
	 */
	Integer getListSize(Long cid, Byte status);
	/**
	 * 
	 * @Comments:  根据日期间隔判断是否需要发放
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年7月10日-下午6:13:01
	 * @param cid 企业id
	 * @param interval 日期间隔（天为单位）
	 * @return null表示没有发放记录 false不需要 true需要
	 */
	Boolean isNeedSend(Long cid, int dayInterval);
	/**
	 * 
	 * @Comments:  获取关键工作中防护用品发放提示信息
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年7月10日-下午6:34:12
	 * @param cid
	 * @param status
	 * @return
	 */
	ShieldSendTips getWorkTips(Long cid, Byte status);
	
	/**
	 * 
	 * 
	 * @Comments:  档案2表11防护用品发放记录
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年9月4日-下午4:15:10
	 * @param cid
	 * @param year
	 * @return 
	 */
	List<ShieldSend> doc2Table11(Long cid,Integer year);
	
	/**
	 * 
	 * 
	 * @Comments:  年度未完成/已完成发放记录数
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年9月5日-下午4:34:30
	 * @param cid
	 * @param status
	 * @return
	 */
	Integer getListSize(Long cid, byte status,String year);

	/**
	 * 
	 * 
	 * @Comments:  <作废>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年4月10日-下午2:20:40
	 * @param ids（多个以逗号隔开）
	 * @param staffId
	 * @param cid
	 */
	void cancelByIds(String ids, Long staffId, Long cid);
	
	/**
	 * 
	 * 
	 * @Comments:  <职业病危害分险分类分级评定接口>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年8月3日-上午9:14:09
	 * @param cid
	 * @return
	 */
	ShieldSendInfo getShieldSendInfo(Long cid);

    ShieldSend clone(Long id, Long staffId, Long cid);

	/**
	 * 发放统计 v2.9 邓力宾 2019-10-12 09:38:23
	 * @param name 防护用品名称
	 * @param orgId 部门id
	 * @param startDate 发放日期 开始
	 * @param endDate 发放日期 结束
	 * @param cid
	 * @return
	 */
	List<ShieldSendCountVo> countShieldSend2_9(String name, Long orgId, Date startDate, Date endDate, Long cid);

	/**
	 * 发放统计 v2.10.2 邓力宾 2020-05-15 15:15:30
	 * @param name 防护用品名称
	 * @param orgIds 部门id 多个用逗号隔开
	 * @param startDate 发放日期 开始
	 * @param endDate 发放日期 结束
	 * @param cid
	 * @return
	 */
	List<ShieldSendCountVo> countShieldSend2_10_2(String name, String orgIds, Date startDate, Date endDate, Long cid);

	/**
	 * 发放统计 v2.10.3 严傲 2020-05-28 10:56:30
	 * @param param#name 防护用品名称
	 * @param param#orgIds 部门id 多个用逗号隔开
	 * @param param#startDate 发放日期 开始
	 * @param param#endDate 发放日期 结束
	 * @param param#cid
	 * @param param#exportFlag 导出标识
	 * @return
	 */
    List<ShieldSendCountVo> countShieldSend2_10_3(ShieldSendCountParamVo param);
}
