package cn.smarthse.modules.health.service.work.shield;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.shield.ShieldSend;
import cn.smarthse.modules.health.entity.work.shield.ShieldSendExpireIgnore;
import cn.smarthse.modules.health.entity.work.shield.ShieldSendExpireLog;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldSendExpireLogParam;
import cn.smarthse.modules.health.vo.work.shield.ShieldDetailVo;
import cn.smarthse.modules.health.vo.work.shield.ShieldExpireUserVo;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * @Project
 * @Module
 * @JDK_Vserion 1.8
 * @Author DengLibin
 * @Email dlb@smarthse.cn
 * @Desc 未及时领取防护用品 相关 接口
 * @since 2019/10/10 0010 10:32
 */
public interface IShieldSendExpireService extends IBaseService<ShieldSend> {

    /**
     * 未及时领取防护用品人员清单
     * @param gparam
     * @param nameWorkNo 工号或姓名
     * @param orgId 部门id
     * @param workId 岗位id
     * @param cid 企业id
     * @return
     */
    PageInfo<ShieldExpireUserVo> getUserList(JqGridParam gparam, String nameWorkNo, Long orgId, Long workId, Long cid);

    /**
     * 忽略
     * @param staffId
     * @param shieldId
     */
    void ignore(Long staffId, Long... shieldId);

    /**
     * 移除忽略（发放工作完成时调用）
     * @param sendId 发放工作id
     */
    void removeIgnore(Long sendId);

    /**
     * 查询防护用品详情
     * @param shieldIds
     * @return
     */
    List<ShieldDetailVo> getShieldDetail(Long ... shieldIds);

    /**
     * 统计人数
     * @param cid
     * @return
     */
    Long getUserNum(Long cid);

    /**
     * 未及时领取防护用品统计清单
     * @param gparam
     * @param param 部门、统计时间（“上次领用时间+发放周期”的时间）
     * @return
     */
    PageInfo<ShieldSendExpireLog> getPage(JqGridParam gparam, ShieldSendExpireLogParam param);

    /**
     * 未及时领取防护用品统计导出清单
     * @param param 部门、统计时间（“上次领用时间+发放周期”的时间）
     * @return
     */
    List<ShieldSendExpireLog> getExportList(ShieldSendExpireLogParam param);

    /**
     * 新增过期日志
     */
    void addLogs();
}
