package cn.smarthse.modules.health.service.work.shield;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.shield.ShieldSendExpireLog;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldSendExpireLogParam;
import com.github.pagehelper.PageInfo;

import java.util.List;


public interface IShieldSendExpireLogService extends IBaseService<ShieldSendExpireLog> {

    /**
     * 未及时领取防护用品统计清单
     * @param gparam
     * @param param 部门、统计时间（“上次领用时间+发放周期”的时间）
     * @return
     */
    PageInfo<ShieldSendExpireLog> getPage(JqGridParam gparam, ShieldSendExpireLogParam param);

    /**
     * 未及时领取防护用品统计导出清单
     * @param param 部门、统计时间（“上次领用时间+发放周期”的时间）
     * @return
     */
    List<ShieldSendExpireLog> getExportList(ShieldSendExpireLogParam param);

    /**
     * 新增过期日志
     */
    void addExpireLog();
}
