package cn.smarthse.modules.health.service.work.shield;

import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.shield.ShieldSendExpireIgnore;

/**
 * @Project
 * @Module
 * @JDK_Vserion 1.8
 * @Author DengLibin
 * @Email dlb@smarthse.cn
 * @Desc 防护用品未及时领取人员忽略
 * @since 2019/10/10 0010 16:04
 */
public interface IShieldSendExpireIgnoreService extends IBaseService<ShieldSendExpireIgnore> {


    /**
     * 是否忽略
     * @param staffId 发放对象id
     * @param shieldId 防护品id
     * @return
     */
    boolean isIgnore(Long staffId, Long shieldId);

    /**
     * 忽略
     * @param staffId 发放对象id
     * @param shieldIds  防护品id 可以是多个
     */
    void ignore(Long staffId, Long... shieldIds);

    /**
     * 移除忽略（领取了防护用品后 调用）
     * @param staffId
     * @param shieldId
     */
    void removeIgnore(Long staffId, Long shieldId);
}
