/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */
package cn.smarthse.modules.health.service.work.shield;

import java.util.List;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.shield.ShieldPurchase;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldPurchaseTips;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearWorkService;


//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IShieldPurchaseService extends IBaseService<ShieldPurchase>,IPlanYearWorkService{

	List<ShieldPurchase> listDetails(ShieldPurchase data);

	void deleteByIds(String ids, Long staffId);

	ShieldPurchase insertOrUpdate(ShieldPurchase rule, Long cid, Long staffId);

	ShieldPurchase getDetailById(Long id);

	PageInfo<ShieldPurchase> getList(JqGridParam gparam, ShieldPurchase param);

	/**
	 * 
	 * @Comments:  根据日期间隔判断是否需要采购
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年7月10日-下午6:13:01
	 * @param cid 企业id
	 * @param interval 日期间隔（天为单位）
	 * @return null表示没有采购记录 false不需要 true需要
	 */
	Boolean isNeedPurchase(Long cid,int interval);
	
	/**
	 * 
	 * @Comments:  获取列表总和
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年7月10日-下午6:14:57
	 * @param cid
	 * @param status
	 * @return
	 */
	int getListSize(Long cid,Byte status);
	
	/**
	 * 
	 * @Comments:  获取关键工作中防护用品采购提示信息
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年7月10日-下午6:34:12
	 * @param cid
	 * @param status
	 * @return
	 */
	ShieldPurchaseTips getWorkTips(Long cid, Byte status);

	
	/**
	 * 
	 * 
	 * @Comments:  档案2表11防护用品采购记录
	 * @author yanao [ya@smarthse.cn]
	 * @since 2017年9月4日-下午4:36:11
	 * @param cid
	 * @param year
	 * @return
	 */
	List<ShieldPurchase> doc2Table12(Long cid,Integer year);
	/**
	 * 
	 * 
	 * @Comments:  <作废>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年4月10日-下午2:20:40
	 * @param ids（多个以逗号隔开）
	 * @param staffId
	 * @param cid
	 */
	void cancelByIds(String ids, Long staffId, Long cid);

    ResponseData<Object> importRules(Long purchaseId,List<List<String>> contents, Long staffId, Long cid);
}
