/*
 * Powered By [rapid-framework]
 * Web Site: http://www.rapid-framework.org.cn
 * Google Code: http://code.google.com/p/rapid-framework/
 * Since 2008 - 2017
 */


package cn.smarthse.modules.health.service.work.shield;

import java.util.Date;
import java.util.List;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldEquipRuleImportInfo;
import com.github.pagehelper.PageInfo;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.IBaseService;
import cn.smarthse.modules.health.entity.work.shield.ShieldEquipRule;
import cn.smarthse.modules.health.entity.work.shield.vo.HarmfactorWorkInfo;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldEquipRuleInfo;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldWorkRelation;

//TODO 注册到dobbo服务中心接口定义
//IBaseService接口定义以下接口：
//1.getById(Long id)					根据ID获取实体
//2.getByEntity(T entity)				根据实体条件获取一条实体数据
//3.getListByExample(Example example)	根据example条件查询列表
//4.getCountByExample(Example example)	根据example条件统计数量
//5.add(T entity)						新增一条数据，并返回实体（带ID）
//6.update(T entity)					更新记录
//7.delete(T entity)					物理删除记录
//8.getListByIds(String ids)			根据ids查询列表
public interface IShieldEquipRuleService extends IBaseService<ShieldEquipRule>{

	PageInfo<ShieldEquipRule> listDetails(int pageIndex, ShieldEquipRule data);
	ShieldEquipRule getDetailById(Long id);
	ShieldEquipRule insertOrUpdate(ShieldEquipRule rule,Long cid,Long staffId);
	PageInfo<ShieldEquipRule> getList(JqGridParam gparam, ShieldEquipRule param);
	List<ShieldEquipRule> listDetails(ShieldEquipRule data);
	void deleteByIds(String ids, Long staffId,Long cid);
	
	/**
	 * 根据岗位工种获取配备标准中已存在的防护用品种类
	 * */
	List<ShieldWorkRelation> getShieldInfosByWorkId(Long workId,Long cid);
	
	/**
	 * 根据岗位工种获取配备标准中已存在的防护用品种类
	 * */
	ShieldEquipRule getDetailsByWorkId(ShieldEquipRule param);
	
	List<HarmfactorWorkInfo> getHarmfactorListByRule(Long ruleId);
	
	List<ShieldEquipRuleInfo> listDetailInfos(ShieldEquipRule data);
	
	PageInfo<ShieldEquipRuleInfo> getPage(JqGridParam gparam, ShieldEquipRule param);
	ShieldEquipRule getDetailByRule(ShieldEquipRule rule);
	ShieldEquipRule recommendPost(ShieldEquipRule rule, Long cid, Long staffId);
	
	ShieldEquipRule getRuleInfoById(Long ruleId);
	
	void deleteDanger(Long ruleId,Long dangerId);
	/**
	 * 
	 * 
	 * @Comments:  <获取配备标准中已存在的岗位id>
	 * @author yanao [ya@smarthse.cn]
	 * @since 2018年7月18日-上午11:03:29
	 * @param cid
	 * @param excludeWorkId
	 * @return
	 */
	String getExistWorkIds(Long cid,Long excludeWorkId);

	/**
	 * 根据岗位工种获取历史的配备标准中已存在的防护用品种类
	 * */
	List<ShieldWorkRelation> getHistoryShieldInfosByWorkId(Long workId,Long cid,Date date);

	/**
	 * 根据岗位id获取配备标准id 合集 v2.9 邓力宾 2019-10-12 16:20
	 * @param workIds
	 * @return
	 */
	List<Long> getIdsByWorkIds(List<Long> workIds);

    ResponseData<Object> importRules(List<List<String>> contents, Long staffId, Long cid);

	List<ShieldEquipRuleImportInfo> listExistInfos(Long cid);

	void clearOldRule(List<Long> ruleIds);
}
